/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.service;

import com.github.jsonldjava.utils.JsonUtils;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.BadRequestException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GraphQlQueryRequest {
    private static final Pattern INTROSPECTION_PATTERN_CHECK = Pattern.compile("__[tT]ype(?!name)|__[sS]chema", 64);
    private static final String QUERY_KEY = "query";
    private static final String VARIABLES_KEY = "variables";
    private static final String OPERATION_NAME_KEY = "operationName";
    private final String query;
    private final Map<String, Object> variables;
    private String operationName;
    private final boolean introspectionRequest;

    public static GraphQlQueryRequest parse(String request) {
        try {
            Map parsed = (Map)JsonUtils.fromString((String)request);
            return GraphQlQueryRequest.getGraphQlQueryRequest(parsed, request);
        }
        catch (IOException | ClassCastException ex) {
            throw new BadRequestException("Invalid request: " + request, ErrorCode.INVALID_QUERY_REQUEST);
        }
    }

    public static GraphQlQueryRequest from(String query, Object variables, String operationName) {
        LinkedHashMap<String, Object> parsed = new LinkedHashMap<String, Object>();
        parsed.put(QUERY_KEY, query);
        parsed.put(VARIABLES_KEY, variables);
        parsed.put(OPERATION_NAME_KEY, operationName);
        return GraphQlQueryRequest.getGraphQlQueryRequest(parsed, query);
    }

    private static GraphQlQueryRequest getGraphQlQueryRequest(Map<String, Object> parsed, String request) {
        return new GraphQlQueryRequest(GraphQlQueryRequest.readQuery(parsed, request), GraphQlQueryRequest.readVariables(parsed), GraphQlQueryRequest.readOperationName(parsed));
    }

    private static String readQuery(Map<String, Object> parsed, String request) {
        Object query = parsed.get(QUERY_KEY);
        if (query == null) {
            throw new BadRequestException("Request does not include a query : " + request, ErrorCode.MISSING_QUERY);
        }
        return query.toString();
    }

    private static Map<String, Object> readVariables(Map<String, Object> parsed) {
        if (!parsed.containsKey(VARIABLES_KEY)) {
            return null;
        }
        Object var = parsed.get(VARIABLES_KEY);
        if (var == null) {
            return null;
        }
        if (var instanceof String) {
            if (StringUtils.isBlank((CharSequence)var.toString())) {
                return null;
            }
            try {
                var = JsonUtils.fromString((String)var.toString());
            }
            catch (IOException ex) {
                throw new BadRequestException("Not valid variables format: " + String.valueOf(var), ErrorCode.INVALID_VARIABLES);
            }
        }
        if (var instanceof Map) {
            return (Map)var;
        }
        throw new BadRequestException("Not valid variables format: " + String.valueOf(var), ErrorCode.INVALID_VARIABLES);
    }

    private static String readOperationName(Map<String, Object> parsed) {
        if (!parsed.containsKey(OPERATION_NAME_KEY)) {
            return null;
        }
        Object var = parsed.get(OPERATION_NAME_KEY);
        if (var instanceof String) {
            if (StringUtils.isBlank((CharSequence)var.toString())) {
                return null;
            }
            return var.toString();
        }
        if (var == null) {
            return null;
        }
        throw new BadRequestException("Invalid operationName: " + String.valueOf(var), ErrorCode.INVALID_OPERATION_NAME);
    }

    private GraphQlQueryRequest(String query, Map<String, Object> variables, String operationName) {
        this.query = query;
        this.variables = variables;
        this.operationName = operationName;
        this.introspectionRequest = INTROSPECTION_PATTERN_CHECK.matcher(query).find();
    }

    public String getQuery() {
        return this.query;
    }

    public Optional<Map<String, Object>> getVariables() {
        return Optional.ofNullable(this.variables);
    }

    public Optional<String> getOperationName() {
        return Optional.ofNullable(this.operationName);
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public boolean isIntrospectionRequest() {
        return this.introspectionRequest;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GraphQlQueryRequest)) {
            return false;
        }
        GraphQlQueryRequest that = (GraphQlQueryRequest)obj;
        return this.query.equals(that.query) && Objects.equals(this.variables, that.variables) && Objects.equals(this.operationName, that.operationName);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.variables, this.operationName);
    }

    public String toString() {
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put(QUERY_KEY, this.getQuery());
        this.getVariables().ifPresent(var -> request.put(VARIABLES_KEY, (String)var));
        this.getOperationName().ifPresent(opName -> request.put(OPERATION_NAME_KEY, (String)opName));
        try {
            return JsonUtils.toString(request);
        }
        catch (IOException ioe) {
            return ((Object)request).toString();
        }
    }
}

