/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.apollo;

import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.soaas.common.CollectionsUtil;
import graphql.GraphQLError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.math3.util.Pair;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private Utils() {
    }

    static List<String> getIds(Arguments arguments) {
        List<Object> representations = Utils.readRepresentations(arguments);
        ArrayList<String> objectIds = new ArrayList<String>(representations.size());
        for (Object object : representations) {
            Map<String, Object> item = Utils.readRepresentationItem(object);
            Object id = item.get("id");
            CollectionsUtil.addIfNotNull(objectIds, (Object)Objects.toString(id, null));
        }
        return objectIds;
    }

    static List<Pair<String, String>> getIdTypePair(Arguments arguments) {
        List<Object> representations = Utils.readRepresentations(arguments);
        ArrayList<Pair<String, String>> objTypePairs = new ArrayList<Pair<String, String>>(representations.size());
        for (Object object : representations) {
            Map<String, Object> item = Utils.readRepresentationItem(object);
            Object id = item.get("id");
            Object typename = item.get("__typename");
            if (id == null || typename == null) continue;
            objTypePairs.add((Pair<String, String>)Pair.create((Object)id.toString(), (Object)typename.toString()));
        }
        return objTypePairs;
    }

    private static List<Object> readRepresentations(Arguments arguments) {
        Object representations = arguments.get((Object)"representations");
        List<Object> objects = Collections.emptyList();
        if (representations instanceof Map) {
            objects = Collections.singletonList(representations);
        } else if (representations instanceof Collection) {
            objects = new ArrayList((Collection)representations);
        } else if (representations != null) {
            throw Utils.unexpectedRepresentationsType(representations);
        }
        return objects;
    }

    private static Map<String, Object> readRepresentationItem(Object item) {
        if (item instanceof Map) {
            return (Map)item;
        }
        throw Utils.unsupportedRepresentationsValue(item);
    }

    @NotNull
    private static InvalidOperationException unsupportedRepresentationsValue(Object object) {
        return new InvalidOperationException("Invalid argument type", (GraphQLError)SimpleGraphQlError.newValidationError((SourceLocation)null, (String)("Unsupported 'representations' value expected 'dictionary{id __typename}' got " + String.valueOf(object))));
    }

    @NotNull
    private static InvalidOperationException unexpectedRepresentationsType(Object representations) {
        return new InvalidOperationException("Invalid argument type", (GraphQLError)SimpleGraphQlError.newValidationError((SourceLocation)null, (String)("Unsupported 'representations' type expected 'list' or 'dictionary' got " + representations.getClass().getSimpleName())));
    }
}

