/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.apollo;

import com.ontotext.graphql.responder.EndpointExecution;
import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.QueryExecution;
import com.ontotext.graphql.responder.QueryExecutionRequest;
import com.ontotext.licensecheck.GraphQlExtendedFeatures;
import com.ontotext.licensecheck.LicenseCheckUtil;
import com.ontotext.metamodel.BoundServiceState;
import com.ontotext.metamodel.SomlSchemaManager;
import com.ontotext.metamodel.storage.SomlBindException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.Operation;
import com.ontotext.models.Selectable;
import com.ontotext.models.SomlConversionException;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaConverter;
import com.ontotext.models.query.Query;
import com.ontotext.platform.GraphQlPrinterUtil;
import com.ontotext.platform.SomlToGraphQlSchemaConverter;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.configuration.GraphqlOptions;
import com.ontotext.soaas.query.GraphQlSchemaConverterBuilder;
import com.ontotext.soaas.query.apollo.FullGraphQlIntrospectionEndpoint;
import com.ontotext.soaas.query.apollo.TemporarySchemaStorage;
import graphql.schema.GraphQLSchema;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullGraphQlIntrospectionEndpointInvoker
implements EndpointInvoker<FullGraphQlIntrospectionEndpoint, QueryExecution, QueryExecutionRequest, RdfTree> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SDL_GRAPHQL = "sdl.graphql";
    private static final String FULL_SDL_GRAPHQL = "fullSdl.graphql";
    private final BoundServiceState schemaManager;
    private final GraphQlSchemaConverterBuilder fullSchemaBuilder;
    private final TemporarySchemaStorage schemaStorage;
    private GraphqlOptions graphqlOptions;
    private final ExecutorService schemaLoader;

    public FullGraphQlIntrospectionEndpointInvoker(GraphqlOptions graphqlOptions, SomlSchemaManager schemaManager, GraphQlSchemaConverterBuilder fullSchemaBuilder) {
        this(graphqlOptions, (BoundServiceState)schemaManager, fullSchemaBuilder, TemporarySchemaStorage.storeInMemory());
    }

    public FullGraphQlIntrospectionEndpointInvoker(GraphqlOptions graphqlOptions, BoundServiceState schemaManager, GraphQlSchemaConverterBuilder fullSchemaBuilder, TemporarySchemaStorage schemaStorage) {
        this.graphqlOptions = graphqlOptions;
        this.schemaManager = schemaManager;
        this.fullSchemaBuilder = fullSchemaBuilder;
        this.schemaStorage = schemaStorage;
        this.schemaLoader = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable, "schema-loader");
            thread.setDaemon(true);
            return thread;
        });
        schemaStorage.clear();
        if (schemaManager instanceof SomlSchemaManager) {
            SomlSchemaManager manager = (SomlSchemaManager)schemaManager;
            manager.registerSchemaChangeListener(updated -> this.reloadSchemaAsync(manager, schemaStorage));
            manager.registerSchemaRemovedListener(oldSoml -> schemaStorage.clear());
        }
    }

    private void reloadSchemaAsync(SomlSchemaManager schemaManager, TemporarySchemaStorage schemaStorage) {
        schemaStorage.clear();
        this.schemaLoader.submit(() -> {
            boolean loaded = false;
            while (!loaded) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                try {
                    this.tryGenerate(schemaManager);
                    loaded = true;
                }
                catch (UnreachableStoreException use) {
                    LOGGER.warn("Could not generate GraphQL schema cache: {}", (Object)use.getMessage());
                }
                catch (SomlBindException sbe) {
                    LOGGER.warn("SOML not bound. Skipping cache generation");
                    return;
                }
            }
        });
    }

    private void tryGenerate(SomlSchemaManager schemaManager) throws UnreachableStoreException {
        if (schemaManager.hasBoundSchema()) {
            SomlSchema somlSchema = schemaManager.getSomlSchema();
            this.generateSchema(somlSchema, FULL_SDL_GRAPHQL, this.fullSdlGenerator());
            if (this.graphqlOptions.getFederation().isEnabled()) {
                this.generateSchema(somlSchema, SDL_GRAPHQL, this.federationGenerator());
            }
        }
    }

    public List<EndpointExecutionResponse<RdfTree>> invoke(FullGraphQlIntrospectionEndpoint endpoint, QueryExecutionRequest executionContext) {
        ArrayList<EndpointExecutionResponse<RdfTree>> resp = new ArrayList<EndpointExecutionResponse<RdfTree>>(executionContext.getExecutions().size());
        for (QueryExecution execution : executionContext.getExecutions()) {
            Query op = execution.getGraphQuery();
            RdfTree data = EntityPoolFactory.defaultPool().emptyTree();
            EntityPool pool = data.getPool();
            RdfPath path = pool.toPath("http://www.ontotext.com/semantic-object/result/", "http://www.ontotext.com/semantic-object/result/_service", (Object)"http://www.ontotext.com/semantic-object/result/service");
            String somlString = "";
            for (Selectable selection : op.getSelections()) {
                String selectionName = selection.getName();
                if (selectionName.equals("sdl") && this.graphqlOptions.getFederation().isEnabled()) {
                    LicenseCheckUtil.requireGraphQlExtendedLicense((GraphQlExtendedFeatures[])new GraphQlExtendedFeatures[]{GraphQlExtendedFeatures.GRAPH_QL_FEDERATION});
                    somlString = this.loadCachedSchema(executionContext.getSomlSchema(), SDL_GRAPHQL, this.federationGenerator());
                }
                if (selectionName.equals("full_sdl")) {
                    somlString = this.loadCachedSchema(executionContext.getSomlSchema(), FULL_SDL_GRAPHQL, this.fullSdlGenerator());
                }
                data.add(path, executionContext.getSomlSchema().getPrefixes().toIri(selectionName), (Object)somlString);
            }
            resp.add((EndpointExecutionResponse<RdfTree>)EndpointExecutionResponse.of((EndpointExecution)execution, (Operation)op, (Object)data));
        }
        return resp;
    }

    private String loadCachedSchema(SomlSchema somlSchema, String name, SchemaPrinter contentGenerator) {
        String schema;
        try {
            schema = this.schemaStorage.readSchemaAsString(name);
        }
        catch (IOException ex) {
            throw new PlatformConfigurationException("Could not read temporary schema" + ex.getMessage(), ErrorCode.COULD_NOT_ACCESS_TEMP_SCHEMA);
        }
        if (schema != null) {
            LOGGER.debug("Loaded schema from cache for: {}", (Object)name);
            return schema;
        }
        return this.generateSchema(somlSchema, name, contentGenerator);
    }

    private String generateSchema(SomlSchema somlSchema, String name, SchemaPrinter contentGenerator) {
        try {
            String generatedSchema = (String)contentGenerator.convert(somlSchema);
            this.schemaStorage.writeSchema(name, generatedSchema);
            return generatedSchema;
        }
        catch (SomlConversionException | IOException ex) {
            throw new PlatformConfigurationException("Could not write temporary schema" + ex.getMessage(), ErrorCode.COULD_NOT_WRITE_TEMP_SCHEMA);
        }
    }

    @NotNull
    private SchemaPrinter federationGenerator() {
        return schema -> {
            LOGGER.debug("Generating sdl response");
            return GraphQlPrinterUtil.print((GraphQLSchema)this.schemaManager.getGraphQlSchema(), (Set)GraphQlPrinterUtil.NON_FEDERATED_DIRECTIVES);
        };
    }

    private SchemaPrinter fullSdlGenerator() {
        return somlSchema -> {
            SomlToGraphQlSchemaConverter schemaConverter = this.fullSchemaBuilder.buildWithRbac();
            LOGGER.debug("Generating full_sdl response");
            return GraphQlPrinterUtil.print((GraphQLSchema)((GraphQLSchema)schemaConverter.convert(somlSchema)));
        };
    }

    public Class<FullGraphQlIntrospectionEndpoint> getEndpointType() {
        return FullGraphQlIntrospectionEndpoint.class;
    }

    public Class<QueryExecutionRequest> getExecutionRequestType() {
        return QueryExecutionRequest.class;
    }

    public void close() {
        this.schemaLoader.shutdown();
    }

    private static interface SchemaPrinter
    extends SomlSchemaConverter<String> {
    }
}

