/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.apollo;

import com.ontotext.graphql.responder.RequestPostProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.query.Query;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.query.apollo.ExtendedResultRdfTree;
import com.ontotext.soaas.query.apollo.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Pair;

public class FederationRequestPostProcessor
implements RequestPostProcessor {
    public static final String QUERY = "http://www.ontotext.com/semantic-object/result/_entities";
    private static final String SO_TYPE_IRI = "http://www.ontotext.com/semantic-object/type";

    public TransformContext postProcess(TransformContext ctx) {
        Operation operation = ctx.getOperation();
        RdfTree data = ctx.getData();
        if (operation instanceof Query && operation.getName().equals("_entities") && data != null) {
            EntityPool pool = data.getPool();
            List<Pair<String, String>> idTypePairs = Utils.getIdTypePair(operation.getArguments());
            if (!idTypePairs.isEmpty()) {
                ExtendedResultRdfTree tree = new ExtendedResultRdfTree(data, idTypePairs.stream().map(Pair::getKey).collect(Collectors.toList()));
                HashSet existingIds = new HashSet(data.getResultIris("_entities"));
                idTypePairs.forEach(idTypePair -> {
                    if (existingIds.contains(idTypePair.getKey())) {
                        return;
                    }
                    RdfPath path = pool.toPath("http://www.ontotext.com/semantic-object/result/", QUERY, idTypePair.getKey()).add(SO_TYPE_IRI, idTypePair.getValue());
                    tree.add(path);
                });
                return new TransformContext(operation, (RdfTree)tree, ctx.getExtensions(), ctx.getIndex());
            }
        }
        return ctx;
    }
}

