/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query;

import com.ontotext.graphql.parser.argument.optimization.StatisticsCollectorManager;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.InfoOperation;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.extensions.Severity;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.connection.EndpointBuilder;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.soaas.common.exceptions.PlatformQueryExecutionException;
import com.ontotext.soaas.query.GraphQlRepositoryAccessControl;
import com.ontotext.soaas.query.apollo.FullGraphQlIntrospectionEndpoint;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import graphql.ErrorClassification;
import graphql.ErrorType;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DynamicEndpointProvider
implements EndpointBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern CLAIM_KEY_PATTERN = Pattern.compile("\\$\\{ctx\\.claims\\.([\\w-]+):?([\\w-]+)?}");
    private EndpointProvider endpointProvider;
    private StatisticsCollectorManager statisticsCollector;
    private final SecurityContext securityContext;

    public DynamicEndpointProvider(EndpointProvider endpointProvider, StatisticsCollectorManager statisticsCollector, SecurityContext securityContext) {
        this.endpointProvider = endpointProvider;
        this.statisticsCollector = statisticsCollector;
        this.securityContext = securityContext;
    }

    public Endpoint buildEndpoint(String repositoryFromQuery) {
        Endpoint endpoint = this.endpointProvider.getEndpoint();
        if (endpoint instanceof SparqlEndpoint) {
            SparqlEndpoint sparqlEndpoint = (SparqlEndpoint)endpoint;
            boolean customRepo = false;
            if (sparqlEndpoint.getRepository() != null && sparqlEndpoint.getRepository().startsWith("$")) {
                customRepo = this.resolveRepositoryFromTokenClaims(sparqlEndpoint);
            }
            if (!customRepo) {
                customRepo = this.resolveRepositoryFromRequest(repositoryFromQuery, null, sparqlEndpoint);
            }
            if (customRepo) {
                this.checkIfRepositoryIsAllowed(sparqlEndpoint.getRepository());
            }
        }
        return endpoint;
    }

    public Endpoint getEndpoint(Operation operation, boolean healthCheckRequest) {
        if ("_service".equals(operation.getName())) {
            return new FullGraphQlIntrospectionEndpoint();
        }
        if (operation.getOperationType() == OperationType.INFO) {
            return InfoOperation.ENDPOINT;
        }
        Endpoint endpoint = healthCheckRequest ? this.endpointProvider.getHealthEndpoint() : this.endpointProvider.getEndpoint();
        if (endpoint instanceof SparqlEndpoint) {
            SparqlEndpoint sparqlEndpoint = (SparqlEndpoint)endpoint;
            boolean customRepo = false;
            if (sparqlEndpoint.getRepository() != null && sparqlEndpoint.getRepository().startsWith("$")) {
                customRepo = this.resolveRepositoryFromTokenClaims(sparqlEndpoint);
            }
            if (!customRepo) {
                String repositoryFromRequest = operation.getArguments().getRepository().map(StringUtils::trimToNull).orElse(null);
                customRepo = this.resolveRepositoryFromRequest(repositoryFromRequest, operation, sparqlEndpoint);
            }
            if (sparqlEndpoint.getRepository() == null) {
                String message = String.format("ERROR: %s: Cannot execute request as no repository is set!", ErrorCode.MISSING_REPOSITORY.getCode());
                DynamicEndpointProvider.throwValidationError(message, ErrorCode.MISSING_REPOSITORY);
            }
            if (customRepo) {
                this.checkIfRepositoryIsAllowed(sparqlEndpoint.getRepository());
            }
            operation.getArguments().setRepository(sparqlEndpoint.getRepository());
        }
        return endpoint;
    }

    private boolean resolveRepositoryFromRequest(String repositoryFromOperation, Operation operation, SparqlEndpoint endpoint) {
        boolean customRepo;
        String repositoryFromHeader = SparqlEndpointRequestContext.getRepository();
        if (repositoryFromHeader != null) {
            endpoint.setRepository(repositoryFromHeader);
            LOGGER.trace("Using repository '{}' from HTTP header", (Object)repositoryFromHeader);
            customRepo = true;
        } else if (repositoryFromOperation != null) {
            customRepo = true;
            endpoint.setRepository(repositoryFromOperation);
            LOGGER.trace("Using repository '{}' from request parameter", (Object)repositoryFromOperation);
        } else if (endpoint.getRepository() == null && operation != null) {
            Optional repositoryConfig = operation.getSchema().getConfig().getRepository();
            repositoryConfig.ifPresent(repository -> {
                endpoint.setRepository(repository);
                LOGGER.trace("Using repository '{}' from schema config", repository);
            });
            customRepo = repositoryConfig.isPresent();
        } else {
            customRepo = false;
        }
        return customRepo;
    }

    private void checkIfRepositoryIsAllowed(String repository) {
        if (this.endpointProvider instanceof GraphQlRepositoryAccessControl && !((GraphQlRepositoryAccessControl)this.endpointProvider).isRepositoryAllowed(repository)) {
            String message = String.format("ERROR: %s: Cannot execute request as repository '%s' is not listed in the repository whitelist!", ErrorCode.REPOSITORY_NOT_ALLOWED.getCode(), repository);
            DynamicEndpointProvider.throwValidationError(message, ErrorCode.REPOSITORY_NOT_ALLOWED);
        }
    }

    private boolean resolveRepositoryFromTokenClaims(SparqlEndpoint endpoint) {
        String repository = endpoint.getRepository();
        Matcher matcher = CLAIM_KEY_PATTERN.matcher(repository);
        if (!matcher.matches()) {
            String message = String.format("ERROR: %s: Invalid repository mapping: '%s'. Expected format is: '${ctx.claims.<claim_key_to_repository>:<default_repository>}'", ErrorCode.BAD_CONFIG_REPOSITORY_NOT_FOUND.getCode(), repository);
            return (Boolean)DynamicEndpointProvider.throwValidationError(message, ErrorCode.BAD_CONFIG_REPOSITORY_NOT_FOUND);
        }
        String claimKey = matcher.group(1);
        String defaultRepo = StringUtils.trimToNull((String)matcher.group(2));
        String repositoryFromClaim = (String)this.securityContext.getClaimValue(claimKey, String.class);
        if (repositoryFromClaim != null) {
            LOGGER.trace("Using '{}' repository from claim '{}'", (Object)repositoryFromClaim, (Object)claimKey);
            endpoint.setRepository(repositoryFromClaim);
            return true;
        }
        endpoint.setRepository(defaultRepo);
        return false;
    }

    private static <E> E throwValidationError(String message, ErrorCode errorCode) {
        SimpleGraphQlError error = new SimpleGraphQlError(Severity.ERROR, message, null, (ErrorClassification)ErrorType.ValidationError, null);
        throw new PlatformQueryExecutionException(errorCode.getHttpCode(), Collections.singletonMap("errors", error.toSpecification()), Collections.singletonList(message));
    }

    public StatisticsCollectorManager getEndpointStatistics() {
        return this.statisticsCollector;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }
}

