/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.SolrClientBuilder;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientCache
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MIN_TIMEOUT = 60000;
    private static final int minConnTimeout = Math.max(Integer.getInteger("connTimeout", 60000), 60000);
    private static final int minSocketTimeout = Math.max(Integer.getInteger("socketTimeout", 60000), 60000);
    private final Map<String, SolrClient> solrClients = new HashMap<String, SolrClient>();
    private final HttpClient apacheHttpClient;
    private final Http2SolrClient http2SolrClient;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicReference<String> defaultZkHost = new AtomicReference();

    public SolrClientCache() {
        this.apacheHttpClient = null;
        this.http2SolrClient = null;
    }

    @Deprecated(since="9.0")
    public SolrClientCache(HttpClient apacheHttpClient) {
        this.apacheHttpClient = apacheHttpClient;
        this.http2SolrClient = null;
    }

    public SolrClientCache(Http2SolrClient http2SolrClient) {
        this.apacheHttpClient = null;
        this.http2SolrClient = http2SolrClient;
    }

    public void setDefaultZKHost(String zkHost) {
        if (zkHost != null) {
            if (!(zkHost = zkHost.split("/")[0]).isEmpty()) {
                this.defaultZkHost.set(zkHost);
            } else {
                this.defaultZkHost.set(null);
            }
        }
    }

    public synchronized CloudSolrClient getCloudSolrClient(String zkHost) {
        this.ensureOpen();
        Objects.requireNonNull(zkHost, "ZooKeeper host cannot be null!");
        if (this.solrClients.containsKey(zkHost)) {
            return (CloudSolrClient)this.solrClients.get(zkHost);
        }
        String zkHostNoChroot = zkHost.split("/")[0];
        boolean canUseACLs = Optional.ofNullable(this.defaultZkHost.get()).map(zkHostNoChroot::equals).orElse(false);
        Object client = this.apacheHttpClient != null ? SolrClientCache.newCloudLegacySolrClient(zkHost, this.apacheHttpClient, canUseACLs) : SolrClientCache.newCloudHttp2SolrClient(zkHost, this.http2SolrClient, canUseACLs);
        this.solrClients.put(zkHost, (SolrClient)client);
        return client;
    }

    @Deprecated
    private static CloudSolrClient newCloudLegacySolrClient(String zkHost, HttpClient httpClient, boolean canUseACLs) {
        List<String> hosts = List.of(zkHost);
        CloudLegacySolrClient.Builder builder = new CloudLegacySolrClient.Builder(hosts, Optional.empty());
        builder.canUseZkACLs(canUseACLs);
        SolrClientCache.adjustTimeouts(builder, httpClient);
        CloudLegacySolrClient client = builder.build();
        try {
            client.connect();
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)client);
            throw e;
        }
        return client;
    }

    private static CloudHttp2SolrClient newCloudHttp2SolrClient(String zkHost, Http2SolrClient http2SolrClient, boolean canUseACLs) {
        List<String> hosts = List.of(zkHost);
        CloudHttp2SolrClient.Builder builder = new CloudHttp2SolrClient.Builder(hosts, Optional.empty());
        builder.canUseZkACLs(canUseACLs);
        builder = builder.withInternalClientBuilder(SolrClientCache.newHttp2SolrClientBuilder(null, http2SolrClient));
        CloudHttp2SolrClient client = builder.build();
        try {
            client.connect();
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)client);
            throw e;
        }
        return client;
    }

    public synchronized SolrClient getHttpSolrClient(String baseUrl) {
        this.ensureOpen();
        Objects.requireNonNull(baseUrl, "Url cannot be null!");
        if (this.solrClients.containsKey(baseUrl)) {
            return this.solrClients.get(baseUrl);
        }
        Object client = this.apacheHttpClient != null ? SolrClientCache.newHttpSolrClient(baseUrl, this.apacheHttpClient) : SolrClientCache.newHttp2SolrClientBuilder(baseUrl, this.http2SolrClient).build();
        this.solrClients.put(baseUrl, (SolrClient)client);
        return client;
    }

    @Deprecated
    private static SolrClient newHttpSolrClient(String baseUrl, HttpClient httpClient) {
        HttpSolrClient.Builder builder = new HttpSolrClient.Builder(baseUrl);
        SolrClientCache.adjustTimeouts(builder, httpClient);
        return builder.build();
    }

    @Deprecated
    private static void adjustTimeouts(SolrClientBuilder<?> builder, HttpClient httpClient) {
        builder.withHttpClient(httpClient);
        int socketTimeout = Math.max(minSocketTimeout, builder.getSocketTimeoutMillis());
        builder.withSocketTimeout(socketTimeout, TimeUnit.MILLISECONDS);
        int connTimeout = Math.max(minConnTimeout, builder.getConnectionTimeoutMillis());
        builder.withConnectionTimeout(connTimeout, TimeUnit.MILLISECONDS);
    }

    private static Http2SolrClient.Builder newHttp2SolrClientBuilder(String baseUrl, Http2SolrClient http2SolrClient) {
        Http2SolrClient.Builder builder = new Http2SolrClient.Builder(baseUrl);
        if (http2SolrClient != null) {
            builder = builder.withHttpClient(http2SolrClient);
        }
        long idleTimeout = minSocketTimeout;
        if (builder.getIdleTimeoutMillis() != null) {
            idleTimeout = Math.max(idleTimeout, builder.getIdleTimeoutMillis());
        }
        builder.withIdleTimeout(idleTimeout, TimeUnit.MILLISECONDS);
        long connTimeout = minConnTimeout;
        if (builder.getConnectionTimeout() != null) {
            connTimeout = Math.max(idleTimeout, builder.getConnectionTimeout());
        }
        builder.withConnectionTimeout(connTimeout, TimeUnit.MILLISECONDS);
        return builder;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            for (Map.Entry<String, SolrClient> entry : this.solrClients.entrySet()) {
                IOUtils.closeQuietly((Closeable)((Closeable)entry.getValue()));
            }
            this.solrClients.clear();
        }
    }

    private void ensureOpen() {
        if (this.isClosed.get()) {
            throw new AlreadyClosedException();
        }
    }
}

