/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sparql;

import com.ontotext.forest.sparql.SavedQueriesService;
import com.ontotext.forest.sparql.SavedQuery;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/rest/sparql/saved-queries"})
@Controller
@Tag(name="Saved Queries Management/Execution", description="Manage and execute saved queries")
public class SavedQueriesController {
    public static final String MAPPING = "/rest/sparql/saved-queries";
    @Autowired
    private SavedQueriesService savedQueriesService;

    @GetMapping
    @Operation(summary="Get all saved queries visible for the user or single saved query by name and owner.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SavedQuery.class)))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @ResponseBody
    public ResponseEntity<?> getQueries(@Parameter(description="The name of the query") @RequestParam(required=false) String name, @RequestParam(required=false) String owner) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            if (!StringUtils.isEmpty((CharSequence)owner)) {
                return new ResponseEntity(this.savedQueriesService.getSavedQueriesOwnedBy(owner), (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity(this.savedQueriesService.getSavedQueries(), (HttpStatusCode)HttpStatus.OK);
        }
        if (StringUtils.isEmpty((CharSequence)owner)) {
            return new ResponseEntity(this.savedQueriesService.getSavedQueries().stream().filter(sq -> name.equals(sq.getName())).collect(Collectors.toList()), (HttpStatusCode)HttpStatus.OK);
        }
        try {
            SavedQuery sample = this.savedQueriesService.getSavedQuery(name, owner);
            return new ResponseEntity((Object)sample, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PostMapping
    @Operation(summary="Create a new saved query", responses={@ApiResponse(responseCode="201", description="Created", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @ResponseBody
    public ResponseEntity<?> createQuery(@Valid @RequestBody SavedQuery query) {
        try {
            this.savedQueriesService.createSavedQuery(query);
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT);
        }
    }

    @PutMapping
    @Operation(summary="Edit an existing saved query", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @ResponseBody
    public ResponseEntity<String> updateQuery(@RequestParam String oldQueryName, @RequestBody SavedQuery newQuery) {
        try {
            this.savedQueriesService.editSavedQuery(oldQueryName, newQuery);
            return new ResponseEntity((Object)("Successfully edited '" + newQuery.getName() + "'"), (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping
    @Operation(summary="Delete an existing saved query", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @ResponseBody
    public ResponseEntity<?> deleteSampleQuery(@Parameter(description="The name of the query") @RequestParam String name) {
        try {
            this.savedQueriesService.deleteSavedQuery(name);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

