/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.rdfrank;

import com.ontotext.GraphDBInternalConfigParameters;
import com.ontotext.config.Parameter;
import com.ontotext.config.ParametersSource;
import com.ontotext.trree.util.BigFloatArray;
import java.util.LinkedList;
import java.util.Locale;

class RankUtils {
    private static final String FORMAT_STRING = (String)ParametersSource.parameters().get((Parameter)GraphDBInternalConfigParameters.RDFRANK_FORMAT);
    private static final Locale FORMAT_LOCALE = Locale.US;
    static final int MAGIC = 279803902;
    static final int VERSION = 1;
    static final int PRECISION = 100;

    RankUtils() {
    }

    static int findThresholdIndex(double number, double[] thresholds) {
        if (number <= 0.0) {
            return -1;
        }
        for (int idx = 0; idx < thresholds.length - 1; idx += 2) {
            if (!(thresholds[idx] <= number) || !(number <= thresholds[idx + 1])) continue;
            return idx;
        }
        return -1;
    }

    static double[] computeThresholds(BigFloatArray ranks, int precision) {
        double max;
        BigFloatArray sorted = ranks.clone();
        sorted.sort();
        int idx = 0;
        while (sorted.get((long)idx) <= 0.0f && (long)idx < sorted.length()) {
            ++idx;
        }
        if ((long)idx >= sorted.length()) {
            return new double[0];
        }
        assert ((long)idx < sorted.length() && sorted.get((long)idx) > 0.0f);
        double min = max = (double)sorted.get((long)idx);
        LinkedList<Double> thresholds = new LinkedList<Double>();
        while ((long)(++idx) < sorted.length()) {
            double cur = sorted.get((long)idx);
            if (cur > min * (double)precision) {
                thresholds.add(min);
                thresholds.add(max);
                min = max = cur;
                continue;
            }
            max = cur;
        }
        thresholds.add(min);
        thresholds.add(max);
        idx = 0;
        double[] thresholdsArray = new double[thresholds.size()];
        for (Double t : thresholds) {
            thresholdsArray[idx++] = t;
        }
        return thresholdsArray;
    }

    static String format(float number) {
        return String.format(FORMAT_LOCALE, FORMAT_STRING, Float.valueOf(number));
    }

    static String formatWithDigits(double number, int digits) {
        return String.format(FORMAT_LOCALE, "%.0" + digits + "f", number);
    }
}

