/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.rdfrank;

import com.ontotext.trree.plugin.rdfrank.GraphReader;
import com.ontotext.trree.plugin.rdfrank.RankUtils;
import com.ontotext.trree.plugin.rdfrank.TableStorage;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.util.BigFloatArray;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RankComputer {
    private long limitStatements = Long.MAX_VALUE;
    private long totalIterations = 10L;
    private float dampingFactor = 0.85f;
    private float epsilon = 0.0f;
    private float minRank;
    private float maxRank;
    private File dataDir = null;
    private int entityBitSize = 32;
    private boolean interrupt = false;
    private Logger Logger = LoggerFactory.getLogger(this.getClass());

    RankComputer() {
    }

    double getDampingFactor() {
        return this.dampingFactor;
    }

    void setDampingFactor(float d) {
        this.dampingFactor = d;
    }

    float getEpsilon() {
        return this.epsilon;
    }

    void setEpsilon(float e) {
        this.epsilon = e;
    }

    long getTotalIterations() {
        return this.totalIterations;
    }

    void setMaxIterations(long n) {
        this.totalIterations = n;
    }

    long getLimitStatements() {
        return this.limitStatements;
    }

    void setLimitStatements(long n) {
        this.limitStatements = n;
    }

    void setEntityBitSize(int entityBitSize) {
        this.entityBitSize = entityBitSize;
    }

    private File getDataDir() {
        return this.dataDir;
    }

    void setDataDir(File dir) {
        this.dataDir = dir;
    }

    BigFloatArray compute(GraphReader gr) {
        long dim = gr.nodeCount() + 1L;
        if (this.getDataDir() == null) {
            throw new IllegalArgumentException("No data dir was configured for rank computer");
        }
        String graphPrefix = this.getDataDir().getAbsolutePath() + File.separator + "graph";
        TableStorage storage = new TableStorage(graphPrefix, dim, dim, this.entityBitSize);
        this.Logger.info("Reading repository graph data...");
        long count = 0L;
        gr.reset();
        while (gr.next()) {
            if (++count % 1000000L == 0L) {
                this.Logger.info("Adding {} of {}", (Object)count, (Object)gr.size());
            }
            storage.add(gr.getFrom(), gr.getTo());
            if (!this.interrupt) continue;
            storage.shutDown();
            return null;
        }
        gr.close();
        if (count == 0L) {
            storage.shutDown();
            throw new PluginException("Selected filter does not return any statements.");
        }
        this.Logger.info("Finished reading repository graph data.");
        long t1 = System.currentTimeMillis();
        this.Logger.info("Computing RDF Rank of graph...");
        long size = gr.nodeCount() + 1L;
        BigFloatArray prevRank = new BigFloatArray(size);
        BigFloatArray currRank = new BigFloatArray(size);
        float resetProbability = (1.0f - this.dampingFactor) / (float)size;
        currRank.fill(1.0f / (float)size);
        int iter = 0;
        while ((long)iter < this.totalIterations) {
            this.minRank = 1.0f;
            this.maxRank = 0.0f;
            float totalRank = 0.0f;
            float danglingRank = 0.0f;
            this.Logger.info("Executing iteration #{}", (Object)iter);
            BigFloatArray tempRank = currRank;
            currRank = prevRank;
            prevRank = tempRank;
            currRank.fill(0.0f);
            int idx = 0;
            while ((long)idx < size) {
                TableStorage.Iterator rowIterator = storage.rowIterator(idx);
                long outgoing = rowIterator.size();
                if (outgoing == 0L) {
                    danglingRank += prevRank.get((long)idx);
                } else {
                    float rankEmission = prevRank.get((long)idx) / (float)outgoing;
                    while (rowIterator.hasNext()) {
                        long index = rowIterator.next();
                        currRank.set(index, currRank.get(index) + rankEmission);
                    }
                }
                ++idx;
            }
            danglingRank /= (float)size;
            idx = 0;
            while ((long)idx < size) {
                float value = currRank.get((long)idx);
                value += danglingRank;
                value *= this.dampingFactor;
                currRank.set((long)idx, value += resetProbability);
                totalRank += value;
                ++idx;
            }
            idx = 0;
            while ((long)idx < size) {
                float normalized;
                if (currRank.get((long)idx) < 0.0f) {
                    this.Logger.error("Negative rank detected!");
                }
                if ((normalized = currRank.get((long)idx) / totalRank) < this.minRank) {
                    this.minRank = normalized;
                } else if (normalized > this.maxRank) {
                    this.maxRank = normalized;
                }
                currRank.set((long)idx, normalized);
                ++idx;
            }
            float delta = 0.0f;
            int idx2 = 0;
            while ((long)idx2 < size) {
                if (!(currRank.get((long)idx2) < 0.0f)) {
                    float diff = currRank.get((long)idx2) - prevRank.get((long)idx2);
                    delta = diff < 0.0f ? (delta -= diff) : (delta += diff);
                }
                ++idx2;
            }
            this.Logger.debug("Iteration #{} is different by {}", (Object)iter, (Object)RankUtils.format(delta));
            if (delta <= this.epsilon) break;
            if (this.interrupt) {
                storage.shutDown();
                return null;
            }
            ++iter;
        }
        long t2 = System.currentTimeMillis();
        this.Logger.info("Finished computing RDF Rank in {}s.", (Object)((t2 - t1) / 1000L));
        storage.shutDown();
        return currRank;
    }

    void interrupt() {
        this.interrupt = true;
    }

    double getMinRank() {
        return this.minRank;
    }

    double getMaxRank() {
        return this.maxRank;
    }
}

