/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.rdfrank;

import com.ontotext.trree.plugin.rdfrank.RankUtils;
import com.ontotext.trree.util.BigFloatArray;
import com.ontotext.trree.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

class FileRankWriter {
    private String rankFile;

    FileRankWriter(String rankFile) {
        this.rankFile = rankFile;
    }

    void write(BigFloatArray ranks) {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.rankFile))));
            double[] thresholds = RankUtils.computeThresholds(ranks, 100);
            dos.writeInt(279803902);
            dos.writeInt(1);
            dos.writeInt(thresholds.length);
            for (double threshold : thresholds) {
                dos.writeDouble(threshold);
            }
            int node = 0;
            while ((long)node < ranks.length()) {
                dos.writeInt(node);
                dos.writeDouble(ranks.get((long)node));
                ++node;
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed writing rank to file '" + this.rankFile + "': " + e.getMessage());
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(dos);
                throw throwable;
            }
        }
        FileUtils.closeQuietly((Closeable)dos);
    }
}

