/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt.functions;

import com.ontotext.graphdb.MagicPropertyContext;
import com.ontotext.graphdb.gpt.GptUtil;
import com.ontotext.graphdb.gpt.functions.AbstractGptMagicProperty;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;

public class GptList
extends AbstractGptMagicProperty {
    private static final Pattern LIST_NUMBERS_SPLITTER = Pattern.compile("^\\d+[.)]( |$)", 8);

    public String getURI() {
        return GptList.newIri("list");
    }

    public CloseableIteration<? extends List<? extends Value>> evaluate(MagicPropertyContext context, ValueFactory valueFactory, Value ... args) throws QueryEvaluationException {
        List<List<Value>> result = this.convertResultToList(valueFactory, this.callGpt(AbstractGptMagicProperty.GPTResponseFormat.LIST, context, args));
        return new CollectionIteration(result);
    }

    private List<List<Value>> convertResultToList(ValueFactory valueFactory, String result) {
        List<List<Value>> list = Stream.of(LIST_NUMBERS_SPLITTER.split(result)).map(String::strip).filter(item -> !item.isEmpty()).map(this::trimInnerWhitespace).map(GptUtil::trimQuotes).map(item -> valueFactory.createLiteral(item)).map(Collections::singletonList).collect(Collectors.toList());
        if (list.isEmpty()) {
            list = Collections.singletonList(Collections.singletonList(valueFactory.createLiteral(result)));
        }
        return list;
    }

    private String trimInnerWhitespace(String item) {
        return Stream.of(item.split("\n")).map(String::strip).collect(Collectors.joining("\n"));
    }
}

