/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt.functions;

import com.ontotext.graphdb.ContextAwareMagicProperty;
import com.ontotext.graphdb.MagicPropertyContext;
import com.ontotext.graphdb.gpt.GptClients;
import com.ontotext.graphdb.gpt.GptUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.spin.function.InverseMagicProperty;

public abstract class AbstractGptMagicProperty
implements InverseMagicProperty,
ContextAwareMagicProperty {
    public static final String PREFIX = "http://www.ontotext.com/gpt/";

    public static String newIri(String localName) {
        return PREFIX + localName;
    }

    protected String callGpt(GPTResponseFormat result, MagicPropertyContext context, Value ... args) {
        Double temperature = null;
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 0; i < args.length && (i != args.length - 1 || (temperature = this.parseTemperature(args[i])) == null); ++i) {
            messages.addAll(GptUtil.valueToGptMessages(context.getNamespaces(), args[i]));
        }
        if (messages.isEmpty()) {
            throw new QueryEvaluationException("Provide at least one message");
        }
        switch (result.ordinal()) {
            case 0: {
                messages.add("Answer as a table");
                break;
            }
            case 1: {
                messages.add("Format the answer as a numbered list, and no other text");
            }
        }
        return GptClients.getInstance().chat(Collections.emptyList(), messages, Collections.emptyList(), temperature);
    }

    private Double parseTemperature(Value value) {
        if (value instanceof Literal) {
            try {
                double temperature = ((Literal)value).doubleValue();
                return GptUtil.parseTemperature(Double.toString(temperature));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static enum GPTResponseFormat {
        TABLE,
        LIST,
        DEFAULT;

    }
}

