/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt;

import com.ontotext.graphdb.gpt.GptUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.rdf4j.query.QueryEvaluationException;

class GptExplainParameters {
    private static final Pattern GPT_PATTERN = Pattern.compile("\\s*#\\s*:(gpt(?:[a-z-]+)?):\\s*(.*?)\\s*$");
    String query;
    boolean isGraph;
    Set<String> bindingNames;
    Map<String, String> namespaces;
    boolean queryOnly;
    boolean resultOnly;
    boolean noEval;
    Double temperature;
    String custom;
    List<String> instructions = new ArrayList<String>();

    GptExplainParameters(String queryString, boolean isGraph, Set<String> bindingNames, Map<String, String> namespaces) {
        Pair<String, List<Pair<String, String>>> queryWithHints = this.parseGptHints(queryString);
        this.query = (String)queryWithHints.getOne();
        this.isGraph = isGraph;
        this.bindingNames = bindingNames;
        this.namespaces = namespaces;
        List hints = (List)queryWithHints.getTwo();
        for (Pair hint : hints) {
            String hintId = (String)hint.getOne();
            String hintValue = (String)hint.getTwo();
            switch (hintId) {
                case "gpt-temp": {
                    this.temperature = GptUtil.parseTemperature(hintValue);
                    break;
                }
                case "gpt": {
                    this.instructions.add(hintValue);
                    break;
                }
                case "gpt-query-only": {
                    this.queryOnly = true;
                    if (hintValue.isEmpty()) break;
                    this.custom = hintValue;
                    break;
                }
                case "gpt-result-only": {
                    this.resultOnly = true;
                    if (hintValue.isEmpty()) break;
                    this.custom = hintValue;
                    break;
                }
                case "gpt-no-eval": {
                    this.noEval = true;
                }
            }
        }
        if (this.queryOnly && this.resultOnly) {
            throw new QueryEvaluationException("Specify either :gpt-query-only: or :gpt-result-only: but not both");
        }
    }

    private Pair<String, List<Pair<String, String>>> parseGptHints(String sparqlQuery) {
        ArrayList hints = new ArrayList();
        String cleanedUpQuery = Stream.of(sparqlQuery.split("\\r?\\n")).map(line -> {
            Matcher matcher = GPT_PATTERN.matcher((CharSequence)line);
            while (matcher.find()) {
                hints.add(Tuples.pair((Object)matcher.group(1), (Object)matcher.group(2)));
                line = matcher.replaceFirst("");
                if (!line.isEmpty()) continue;
                line = null;
            }
            return line;
        }).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        return Tuples.pair((Object)cleanedUpQuery, hints);
    }
}

