/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.configs.LLMConfig;
import com.ontotext.graphdb.configs.SystemConfig;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.jdk.JdkHttpClient;
import dev.langchain4j.http.client.jdk.JdkHttpClientBuilder;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.azure.AzureOpenAiChatModel;
import dev.langchain4j.model.azure.AzureOpenAiTokenCountEstimator;
import dev.langchain4j.model.bedrock.BedrockCachePointPlacement;
import dev.langchain4j.model.bedrock.BedrockChatModel;
import dev.langchain4j.model.bedrock.BedrockChatRequestParameters;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.googleai.GoogleAiGeminiChatModel;
import dev.langchain4j.model.googleai.GoogleAiGeminiTokenCountEstimator;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiChatRequestParameters;
import dev.langchain4j.model.openai.OpenAiTokenCountEstimator;
import dev.langchain4j.model.vertexai.gemini.VertexAiGeminiChatModel;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;

public class ChatModelFactory {
    private static final Logger logger = LoggerFactory.getLogger(ChatModelFactory.class);
    public static final String API_NOT_SPECIFIED_ERROR_MSG = String.format("The provided value for %s could not be null", "graphdb.llm.api");

    private ChatModelFactory() {
    }

    public static ChatModel createChatModel(String modelName, double modelTemperature, double modelTopP) {
        String llmApi = LLMConfig.getLLMApi();
        String string = llmApi.toLowerCase(Locale.ROOT);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"openai-completions", "openai-completions-http1.1", "gemini", "vertex", "bedrock"}, (Object)string, n)) {
            case 0 -> {
                if (LLMConfig.isAzure()) {
                    yield ChatModelFactory.createAzureOpenAIChatModel(modelName, modelTemperature, modelTopP);
                }
                yield ChatModelFactory.createOpenAIChatModel(modelName, modelTemperature, modelTopP);
            }
            case 1 -> ChatModelFactory.createOpenAIChatModelWithHttp11(modelName, modelTemperature, modelTopP);
            case 2 -> ChatModelFactory.createGeminiChatModel(modelName, modelTemperature, modelTopP);
            case 3 -> ChatModelFactory.createVertexGemminiChatModel(modelName, modelTemperature, modelTopP);
            case 4 -> ChatModelFactory.createAmazonBedrockChatModel(modelName, modelTemperature, modelTopP);
            case -1 -> throw new IllegalStateException(API_NOT_SPECIFIED_ERROR_MSG);
            default -> throw new IllegalArgumentException("Unsupported API: " + llmApi);
        };
    }

    private static ChatModel createAmazonBedrockChatModel(String modelName, double modelTemperature, double modelTopP) {
        BedrockRuntimeClient bedrockClient = (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(LLMConfig.getAwsRegion())).credentialsProvider(LLMConfig.getAwsCredentialProvider())).build();
        BedrockChatModel.Builder builder = (BedrockChatModel.Builder)((BedrockChatModel.Builder)((BedrockChatModel.Builder)BedrockChatModel.builder().client(bedrockClient).modelId(modelName)).timeout(Duration.ofSeconds(SystemConfig.getApiTimeout()))).defaultRequestParameters((ChatRequestParameters)((BedrockChatRequestParameters.Builder)((BedrockChatRequestParameters.Builder)BedrockChatRequestParameters.builder().promptCaching(BedrockCachePointPlacement.AFTER_SYSTEM).topP(Double.valueOf(modelTopP))).temperature(Double.valueOf(modelTemperature))).build());
        if (logger.isDebugEnabled()) {
            builder.logRequests(Boolean.valueOf(true));
            builder.logResponses(Boolean.valueOf(true));
        }
        return builder.build();
    }

    private static ChatModel createVertexGemminiChatModel(String modelName, double modelTemperature, double modelTopP) {
        VertexAiGeminiChatModel.VertexAiGeminiChatModelBuilder builder = VertexAiGeminiChatModel.builder();
        builder.modelName(modelName).temperature(Float.valueOf((float)modelTemperature)).topP(Float.valueOf((float)modelTopP)).project(LLMConfig.getVertexProjectId()).location(LLMConfig.getVertexLocation());
        try {
            builder.credentials(LLMConfig.getVertexCredentials());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to retrieve credentials due to: " + String.valueOf(e));
        }
        if (logger.isDebugEnabled()) {
            builder.logRequests(Boolean.valueOf(true));
            builder.logResponses(Boolean.valueOf(true));
        }
        return builder.build();
    }

    public static TokenCountEstimator getTokenEstimator(String modelName) {
        String llmApi = LLMConfig.getLLMApi();
        String string = llmApi.toLowerCase(Locale.ROOT);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"openai-completions", "openai-completions-http1.1", "gemini", "vertex", "bedrock"}, (Object)string, n)) {
            case 0, 1 -> {
                if (LLMConfig.isAzure()) {
                    String effectiveModel = modelName.startsWith("gpt-5") ? "gpt-4." : modelName;
                    yield new AzureOpenAiTokenCountEstimator(effectiveModel);
                }
                yield new OpenAiTokenCountEstimator("gpt-4.");
            }
            case 2 -> ChatModelFactory.createGeminiEstimator(modelName);
            case 3, 4 -> new OpenAiTokenCountEstimator("gpt-4.");
            case -1 -> throw new IllegalStateException(API_NOT_SPECIFIED_ERROR_MSG);
            default -> throw new IllegalArgumentException("Unsupported API: " + llmApi);
        };
    }

    public static ChatModel createAzureOpenAIChatModel(String modelName, double modelTemperature, double modelTopP) {
        String baseURL = LLMConfig.getLLMUrl();
        if (baseURL == null) {
            throw new IllegalArgumentException("Azure OpenAI requires base URL to be set in the configuration");
        }
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        AzureOpenAiChatModel.Builder builder = AzureOpenAiChatModel.builder().apiKey(LLMConfig.getLLMApiKeyOrThrow()).deploymentName(modelName).temperature(Double.valueOf(modelTemperature)).topP(Double.valueOf(modelTopP)).endpoint(baseURL).serviceVersion(Config.getProperty((String)"graphdb.gpt-sparql.api-version")).maxRetries(Integer.valueOf(0)).timeout(Duration.ofSeconds(SystemConfig.getApiTimeout()));
        if (logger.isDebugEnabled()) {
            builder.logRequestsAndResponses(Boolean.valueOf(true));
        }
        return builder.build();
    }

    private static ChatModel createGeminiChatModel(String modelName, double modelTemperature, double modelTopP) {
        GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder builder = GoogleAiGeminiChatModel.builder().apiKey(LLMConfig.getLLMApiKeyOrThrow()).modelName(modelName).temperature(Double.valueOf(modelTemperature)).topP(Double.valueOf(modelTopP)).maxRetries(Integer.valueOf(0)).timeout(Duration.ofSeconds(SystemConfig.getApiTimeout()));
        if (logger.isDebugEnabled()) {
            builder.logRequestsAndResponses(Boolean.valueOf(true));
        }
        return builder.build();
    }

    private static TokenCountEstimator createGeminiEstimator(String modelName) {
        return GoogleAiGeminiTokenCountEstimator.builder().modelName(modelName).apiKey(LLMConfig.getLLMApiKeyOrThrow()).build();
    }

    public static ChatModel createOpenAIChatModel(String modelName, double modelTemperature, double modelTopP) {
        return ChatModelFactory.createOpenAiBuilder(modelName, modelTemperature, modelTopP).build();
    }

    private static ChatModel createOpenAIChatModelWithHttp11(String modelName, double modelTemperature, double modelTopP) {
        OpenAiChatModel.OpenAiChatModelBuilder builder = ChatModelFactory.createOpenAiBuilder(modelName, modelTemperature, modelTopP);
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1);
        JdkHttpClientBuilder jdkHttpClientBuilder = JdkHttpClient.builder().httpClientBuilder(httpClientBuilder);
        builder.httpClientBuilder((HttpClientBuilder)jdkHttpClientBuilder);
        return builder.build();
    }

    private static OpenAiChatModel.OpenAiChatModelBuilder createOpenAiBuilder(String modelName, double modelTemperature, double modelTopP) {
        OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder();
        OpenAiChatRequestParameters parameters = ((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)((OpenAiChatRequestParameters.Builder)OpenAiChatRequestParameters.builder().modelName(modelName)).temperature(Double.valueOf(modelTemperature))).topP(Double.valueOf(modelTopP))).build();
        Map<String, String> headers = ChatModelFactory.getOpenAIHeaders();
        Pair<String, String> authHeader = LLMConfig.getLLMAuth();
        if (authHeader != null) {
            headers.put((String)authHeader.getKey(), (String)authHeader.getValue());
        }
        builder.defaultRequestParameters((ChatRequestParameters)parameters).customHeaders(headers).maxRetries(Integer.valueOf(0)).timeout(Duration.ofSeconds(SystemConfig.getApiTimeout()));
        String baseURL = LLMConfig.getLLMUrl();
        if (baseURL != null) {
            builder.baseUrl(baseURL);
        }
        if (logger.isDebugEnabled()) {
            builder.logRequests(Boolean.valueOf(true));
            builder.logResponses(Boolean.valueOf(true));
        }
        return builder;
    }

    public static Map<String, String> getOpenAIHeaders() {
        String project = LLMConfig.getProject();
        String organization = LLMConfig.getOrganization();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (project != null) {
            headers.put("OpenAI-Project", project);
        }
        if (organization != null) {
            headers.put("OpenAI-Organization", organization);
        }
        return headers;
    }
}

