/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt;

import com.ontotext.graphdb.gpt.GptUtil;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.eclipse.collections.api.tuple.Triplet;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;

public class BindingSetPrinter {
    private static final String DELIMITER = "\t";

    public static String printBindings(Set<String> bindingNames, Iterable<BindingSet> bindings, BidiMap<String, String> namespaces) {
        StringBuilder sb = new StringBuilder();
        namespaces.put((Object)"xsd", (Object)"http://www.w3.org/2001/XMLSchema#");
        sb.append(bindingNames.stream().map(bn -> "?" + bn).collect(Collectors.joining(DELIMITER)));
        bindings.forEach(bs -> {
            sb.append("\n");
            sb.append(bindingNames.stream().map(bn -> BindingSetPrinter.printValue(bs.getValue(bn), namespaces)).collect(Collectors.joining(DELIMITER)));
        });
        return sb.toString();
    }

    private static String printValue(Value value, BidiMap<String, String> namespaces) {
        if (value instanceof IRI) {
            Triplet<String> iriNamespace = GptUtil.findIriNamespace(value.stringValue(), namespaces);
            if (iriNamespace != null) {
                return String.format("%s:%s", iriNamespace.getOne(), iriNamespace.getThree());
            }
            StringBuilder sb = new StringBuilder();
            BindingSetPrinter.appendIri(sb, value.stringValue());
            return sb.toString();
        }
        if (value instanceof Triple) {
            return String.format("<<%s %s %s>>", BindingSetPrinter.printValue((Value)((Triple)value).getSubject(), namespaces), BindingSetPrinter.printValue((Value)((Triple)value).getPredicate(), namespaces), BindingSetPrinter.printValue(((Triple)value).getObject(), namespaces));
        }
        if (value instanceof Literal && !Literals.isLanguageLiteral((Literal)((Literal)value))) {
            IRI datatype = ((Literal)value).getDatatype();
            if (datatype != null && !datatype.equals((Object)XSD.STRING)) {
                return String.format("%s^^%s", NTriplesUtil.toNTriplesString((Literal)SimpleValueFactory.getInstance().createLiteral(((Literal)value).getLabel())), BindingSetPrinter.printValue((Value)datatype, namespaces));
            }
        } else if (value == null) {
            return "";
        }
        return NTriplesUtil.toNTriplesString((Value)value);
    }

    private static void appendNamespace(StringBuilder sb, String prefix, String namespace) {
        sb.append("@prefix ");
        sb.append(prefix);
        sb.append(": ");
        BindingSetPrinter.appendIri(sb, namespace);
        sb.append("\n");
    }

    private static void appendIri(StringBuilder sb, String iriString) {
        sb.append("<");
        try {
            StringUtil.simpleEscapeIRI((String)iriString, (Appendable)sb, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        sb.append(">");
    }
}

