/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.configs;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ServiceOptions;
import com.ontotext.graphdb.Config;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.utils.StringUtils;

public class LLMConfig {
    public static final String OPENAI_ASSISTANTS_API = "openai-assistants";
    public static final String OPENAI_COMPLETIONS_API = "openai-completions";
    public static final String OPENAI_COMPLETIONS_HTTP11_API = "openai-completions-http1.1";
    public static final String GEMINI_API = "gemini";
    public static final String VERTEX_API = "vertex";
    public static final String BEDROCK_API = "bedrock";
    public static final String GRAPHDB_LLM_API = "graphdb.llm.api";
    public static final String GRAPHDB_LLM_URL = "graphdb.llm.url";
    public static final String GRAPHDB_LLM_API_KEY = "graphdb.llm.api-key";
    public static final String GRAPHDB_LLM_AUTH = "graphdb.llm.auth";
    public static final String GRAPHDB_LLM_VERTEX_LOCATION = "graphdb.llm.vertex.location";
    public static final String GRAPHDB_LLM_VERTEX_CREDENTIALS_FILE = "graphdb.llm.vertex.credentials.file";
    public static final String GRAPHDB_LLM_VERTEX_PROJECT_ID = "graphdb.llm.vertex.project.id";
    public static final String GRAPHDB_LLM_BEDROCK_ACCESS_KEY_ID = "graphdb.llm.bedrock.accessKeyId";
    public static final String GRAPHDB_LLM_BEDROCK_SECRET_ACCESS_KEY = "graphdb.llm.bedrock.secretAccessKey";
    public static final String GRAPHDB_LLM_BEDROCK_REGION = "graphdb.llm.bedrock.region";
    public static final String OPENAI_API_KEY = "graphdb.openai.api-key";
    public static final String OPENAI_AUTH_METHOD = "graphdb.openai.auth";
    public static final String OPENAI_URL = "graphdb.openai.url";
    public static final String GPT_TOKEN_PROPERTY = "graphdb.gpt.token";
    public static final String GPT_AUTH_PROPERTY = "graphdb.gpt.auth";
    public static final String GPT_URL_PROPERTY = "graphdb.gpt.url";
    public static final String DEFAULT_LLM_API = "openai-assistants";

    public static String getLLMApi() {
        return Config.getProperty((String)GRAPHDB_LLM_API);
    }

    public static String getLLMUrl() {
        String llmUrl = Config.getPropertyOrLegacyProperty((String)GRAPHDB_LLM_URL, (String)OPENAI_URL);
        if (llmUrl == null && (llmUrl = Config.getPropertyOrLegacyProperty((String)GRAPHDB_LLM_URL, (String)GPT_URL_PROPERTY)) != null) {
            llmUrl = llmUrl.split("/openai/")[0];
            return llmUrl;
        }
        return llmUrl;
    }

    public static String getLLMApiKeyOrThrow() {
        String key = LLMConfig.getApiKeyOrNull();
        if (key == null) {
            throw new IllegalStateException("Set the config property 'graphdb.llm.api-key' to your LLM API key");
        }
        return key;
    }

    public static boolean isAzure() {
        return Objects.requireNonNullElse(LLMConfig.getLLMUrl(), "").contains(".azure.com");
    }

    public static Pair<String, String> getLLMAuth() {
        String authMethod = Config.getPropertyOrLegacyProperty((String)OPENAI_AUTH_METHOD, (String)GPT_AUTH_PROPERTY);
        if (authMethod == null) {
            authMethod = Config.getProperty((String)GRAPHDB_LLM_AUTH, (String)"auto");
        }
        if ("auto".equals(authMethod)) {
            authMethod = LLMConfig.isAzure() ? "api-key" : "bearer";
        }
        switch (authMethod.toLowerCase(Locale.ROOT)) {
            case "bearer": {
                return Pair.of((Object)"Authorization", (Object)String.format("Bearer %s", LLMConfig.getLLMApiKeyOrThrow()));
            }
            case "api-key": {
                return Pair.of((Object)"api-key", (Object)LLMConfig.getLLMApiKeyOrThrow());
            }
            case "custom": {
                String[] authTokenParts = LLMConfig.getLLMApiKeyOrThrow().split(":", 2);
                if (authTokenParts.length != 2) {
                    throw new IllegalStateException("Custom auth mode requires a token value of the form headerName:headerValue");
                }
                return Pair.of((Object)authTokenParts[0], (Object)authTokenParts[1]);
            }
            case "none": {
                return null;
            }
        }
        throw new IllegalStateException("Unknown LLM auth method: " + authMethod);
    }

    public static String getApiKeyOrNull() {
        String apiKey = Config.getPropertyOrLegacyProperty((String)GRAPHDB_LLM_API_KEY, (String)OPENAI_API_KEY);
        if (apiKey == null) {
            apiKey = Config.getPropertyOrLegacyProperty((String)GRAPHDB_LLM_API_KEY, (String)GPT_TOKEN_PROPERTY);
        }
        return apiKey;
    }

    public static String getProject() {
        return Config.getProperty((String)"graphdb.openai.project");
    }

    public static String getOrganization() {
        return Config.getProperty((String)"graphdb.openai.organization");
    }

    public static String getVertexLocation() {
        return Config.getProperty((String)GRAPHDB_LLM_VERTEX_LOCATION);
    }

    public static GoogleCredentials getVertexCredentials() throws IOException {
        String credentialsFilePath = Config.getProperty((String)GRAPHDB_LLM_VERTEX_CREDENTIALS_FILE);
        if (credentialsFilePath != null) {
            return GoogleCredentials.fromStream((InputStream)new FileInputStream(credentialsFilePath));
        }
        return GoogleCredentials.getApplicationDefault();
    }

    public static String getVertexProjectId() {
        String projectId = Config.getProperty((String)GRAPHDB_LLM_VERTEX_PROJECT_ID);
        if (projectId == null) {
            projectId = ServiceOptions.getDefaultProjectId();
        }
        return projectId;
    }

    public static AwsCredentialsProvider getAwsCredentialProvider() {
        String accessKey = Config.getProperty((String)GRAPHDB_LLM_BEDROCK_SECRET_ACCESS_KEY);
        String accessKeyId = Config.getProperty((String)GRAPHDB_LLM_BEDROCK_ACCESS_KEY_ID);
        if (StringUtils.isNotBlank((CharSequence)accessKey) && StringUtils.isNotBlank((CharSequence)accessKeyId)) {
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)accessKey));
        }
        return DefaultCredentialsProvider.builder().build();
    }

    public static Region getAwsRegion() {
        String region = Config.getProperty((String)GRAPHDB_LLM_BEDROCK_REGION);
        if (region != null) {
            return Region.of((String)region);
        }
        return new DefaultAwsRegionProviderChain().getRegion();
    }
}

