/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.extended.scalars;

import com.ontotext.platform.extended.scalars.NumericScalarsUtil;
import com.ontotext.platform.extended.scalars.PatternBasedCoercing;
import graphql.GraphQLContext;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;

public class DateTimeScalars {
    private static final Pattern YEAR_PATTERN = Pattern.compile("-?\\d{4,}(Z|([+\\-])\\d\\d:\\d\\d)?");
    private static final Pattern YEAR_MONTH_PATTERN = Pattern.compile("^-?\\d*-(0?[1-9]|1[012])(?:Z|([+\\-])\\d\\d:\\d\\d)?$");
    private static final Pattern TIME_PATTERN = Pattern.compile("^(?:(?:([01]?\\d|2[0-3]):)([0-5]?\\d):)([0-5]?\\d)(?:\\.\\d{1,9})?(?:Z|([+\\-])\\d\\d:\\d\\d)?$");
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("^-?\\d*-(?:0?[1-9]|1[012])-(?:0?[1-9]|[1-2]\\d|3[0-1])T(?:(?:(?:[01]?\\d|2[0-3]):)(?:[0-5]?\\d):)(?:[0-5]?\\d)(?:\\.\\d{1,9})?(?:Z|([+\\-])\\d\\d:\\d\\d)?$");
    public static final GraphQLScalarType YEAR = GraphQLScalarType.newScalar().name("Year").description("An RFC-3339 compliant Year Scalar").coercing((Coercing)new PatternBasedCoercing("Year", YEAR_PATTERN)).build();
    public static final GraphQLScalarType YEAR_MONTH = GraphQLScalarType.newScalar().name("YearMonth").description("An RFC-3339 compliant Year Month Scalar").coercing((Coercing)new PatternBasedCoercing("YearMonth", YEAR_MONTH_PATTERN)).build();
    public static final GraphQLScalarType TIME = GraphQLScalarType.newScalar().name("Time").description("An RFC-3339 compliant time scalar with an optional timezone.").coercing((Coercing)new PatternBasedCoercing("Time", TIME_PATTERN)).build();
    public static final GraphQLScalarType DATE_TIME = GraphQLScalarType.newScalar().name("DateTime").description("An RFC-3339 compliant DateTime Scalar with an optional timezone.").coercing((Coercing)new PatternBasedCoercing("DateTime", DATE_TIME_PATTERN)).build();
    public static final GraphQLScalarType DATE = GraphQLScalarType.newScalar().name("Date").description("An RFC-3339 compliant Full Date Scalar").coercing((Coercing)new DateScalar()).build();

    private DateTimeScalars() {
    }

    private static class DateScalar
    implements Coercing<LocalDate, String> {
        private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd");

        private DateScalar() {
        }

        public String serialize(Object input) {
            TemporalAccessor temporalAccessor;
            if (input instanceof TemporalAccessor) {
                temporalAccessor = (TemporalAccessor)input;
            } else if (input instanceof String) {
                temporalAccessor = this.parseLocalDate(input.toString(), CoercingSerializeException::new);
            } else {
                String msg = "Expected a 'String' or 'java.time.temporal.TemporalAccessor' but was '%s'.";
                throw new CoercingSerializeException(String.format(msg, NumericScalarsUtil.typeName(input)));
            }
            try {
                return dateFormatter.format(temporalAccessor);
            }
            catch (DateTimeException dte) {
                String msg = "Unable to turn TemporalAccessor into full date because of : '%s'.";
                throw new CoercingSerializeException(String.format(msg, dte.getMessage()));
            }
        }

        public LocalDate parseValue(Object input) {
            TemporalAccessor temporalAccessor;
            if (input instanceof TemporalAccessor) {
                temporalAccessor = (TemporalAccessor)input;
            } else if (input instanceof String) {
                temporalAccessor = this.parseLocalDate(input.toString(), CoercingParseValueException::new);
            } else {
                String msg = "Expected a 'String' or 'java.time.temporal.TemporalAccessor' but was '%s'.";
                throw new CoercingParseValueException(String.format(msg, NumericScalarsUtil.typeName(input)));
            }
            try {
                return LocalDate.from(temporalAccessor);
            }
            catch (DateTimeException dte) {
                String msg = "Unable to turn TemporalAccessor into full date because of : '%s'.";
                throw new CoercingParseValueException(String.format(msg, dte.getMessage()));
            }
        }

        public LocalDate parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                String msg = "Expected AST type 'StringValue' but was '%s'.";
                throw new CoercingParseLiteralException(String.format(msg, NumericScalarsUtil.typeName(input)));
            }
            return this.parseLocalDate(((StringValue)input).getValue(), CoercingParseLiteralException::new);
        }

        public Value<?> valueToLiteral(Object input, GraphQLContext graphQlContext, Locale locale) {
            return StringValue.of((String)this.serialize(input));
        }

        private LocalDate parseLocalDate(String input, Function<String, RuntimeException> exceptionMaker) {
            try {
                TemporalAccessor temporalAccessor = dateFormatter.parse(input);
                return LocalDate.from(temporalAccessor);
            }
            catch (DateTimeParseException dtpe) {
                String msg = "Invalid RFC3339 full date value : '%s'. because of : '%s'";
                throw exceptionMaker.apply(String.format(msg, input, dtpe.getMessage()));
            }
        }
    }
}

