/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import graphql.Scalars;
import graphql.schema.Coercing;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Utils {
    private Utils() {
    }

    public static GraphQLDirective.Builder createDirectiveBuilder(String directiveName, String argumentName, String argumentValue) {
        GraphQLDirective.Builder descrDirectiveBuilder = GraphQLDirective.newDirective().name(directiveName);
        if (argumentName != null) {
            GraphQLArgument.Builder descriptionArgumentBuilder = GraphQLArgument.newArgument().name(argumentName).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString));
            if (null != argumentValue) {
                descriptionArgumentBuilder.value((Object)argumentValue);
            }
            descrDirectiveBuilder.argument(descriptionArgumentBuilder);
        }
        return descrDirectiveBuilder;
    }

    public static Map<String, Shape> getObjectsNames(SomlSchema soml) {
        return soml.getObjects().values().stream().filter(shape -> !shape.isSystem()).collect(Collectors.toMap(Shape::asGraphQl, Function.identity()));
    }

    public static class PassThroughCoercing
    implements Coercing {
        public Object serialize(Object dataFetcherResult) {
            return dataFetcherResult;
        }

        public Object parseValue(Object input) {
            return input;
        }

        public Object parseLiteral(Object input) {
            return input;
        }
    }
}

