/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.google.common.collect.ImmutableSet;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.idl.SchemaPrinter;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GraphQlPrinterUtil {
    public static final Set<String> NON_FEDERATED_DIRECTIVES = ImmutableSet.of((Object)"descr", (Object)"hasRole", (Object)"nameAlias", (Object)"constraints", (Object)"somlType", (Object)"somlProperty", (Object[])new String[]{"_Prefixes", "_Configs", "_SomlInfo", "_Rbac"});
    private static final Set<String> defaultDirectives = Stream.of("include", "skip", "defer", "specifiedBy", "deprecated").collect(Collectors.toSet());
    private static final GraphqlTypeComparatorRegistry DEFAULT_COMPARATOR_REGISTRY = GraphqlTypeComparatorRegistry.AS_IS_REGISTRY;

    private GraphQlPrinterUtil() {
    }

    public static void excludeDirective(String directive) {
        defaultDirectives.add(directive);
    }

    public static void includeDirective(String directive) {
        defaultDirectives.remove(directive);
    }

    public static String print(GraphQLType graphQlType) {
        return new SchemaPrinter(SchemaPrinter.Options.defaultOptions().includeDirectives(GraphQlPrinterUtil.excludeDefaultDirectives()).setComparators(DEFAULT_COMPARATOR_REGISTRY)).print(graphQlType);
    }

    public static String print(GraphQLSchema schema) {
        return new SchemaPrinter(SchemaPrinter.Options.defaultOptions().includeSchemaDefinition(true).includeDirectives(GraphQlPrinterUtil.excludeDefaultDirectives()).setComparators(DEFAULT_COMPARATOR_REGISTRY)).print(schema);
    }

    public static String print(GraphQLSchema schema, Set<String> excludedDirectives) {
        return new SchemaPrinter(SchemaPrinter.Options.defaultOptions().includeDirectives(GraphQlPrinterUtil.excludeDefaultDirectives().and(GraphQlPrinterUtil.excludeDirectives(excludedDirectives))).setComparators(DEFAULT_COMPARATOR_REGISTRY)).print(schema);
    }

    public static String print(GraphQLSchema schema, UnaryOperator<SchemaPrinter.Options> optionsTransformer) {
        return new SchemaPrinter((SchemaPrinter.Options)optionsTransformer.apply(SchemaPrinter.Options.defaultOptions())).print(schema);
    }

    public static String printSearchFederated(GraphQLSchema schema) {
        return GraphQlPrinterUtil.print(schema, GraphQlPrinterUtil.searchFederationOptions());
    }

    public static UnaryOperator<SchemaPrinter.Options> searchFederationOptions() {
        return options -> options.includeSchemaElement(GraphQlPrinterUtil.searchFederatedProperties()).includeDirectives(GraphQlPrinterUtil.excludeDefaultDirectives()).includeDirectiveDefinitions(false).setComparators(DEFAULT_COMPARATOR_REGISTRY);
    }

    public static Predicate<String> excludeDefaultDirectives() {
        return GraphQlPrinterUtil.excludeDirectives(defaultDirectives);
    }

    public static Predicate<String> excludeDirectives(Set<String> excludeDirectives) {
        HashSet<String> directivesCopy = new HashSet<String>(excludeDirectives);
        return graphQlDirective -> !directivesCopy.contains(graphQlDirective);
    }

    public static Predicate<GraphQLSchemaElement> searchFederatedProperties() {
        return graphQlSchemaElement -> {
            if (graphQlSchemaElement instanceof GraphQLDirectiveContainer && (graphQlSchemaElement instanceof GraphQLObjectType || graphQlSchemaElement instanceof GraphQLInterfaceType)) {
                return true;
            }
            if (graphQlSchemaElement instanceof GraphQLFieldDefinition) {
                GraphQLFieldDefinition field = (GraphQLFieldDefinition)graphQlSchemaElement;
                if (field.getDirectives().isEmpty() || field.getDirective("external") == null) {
                    return true;
                }
                return field.getName().equals("id") || field.getName().equals("_empty");
            }
            return true;
        };
    }
}

