/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.github.jsonldjava.utils.JsonUtils;
import com.ontotext.models.Configs;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Role;
import com.ontotext.models.RoleAction;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.platform.GraphQlFieldArgumentBuilder;
import com.ontotext.platform.GraphQlTypeUtil;
import com.ontotext.soaas.common.ObjectsUtil;
import graphql.GraphQLContext;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

class DirectivesBuilder {
    private static final GraphQLContext GRAPH_QL_CONTEXT = GraphQLContext.getDefault();
    private static final String DESCRIPTION = "descr";
    private static final String PREFIX = "_Prefix";
    private static final String VALUES = "values";
    private static final String CONFIG = "_Config";
    private static final String RBAC_ROLE = "_RbacRole";
    private static final String RBAC_ROLE_ACTION = "_RbacRoleAction";

    private DirectivesBuilder() {
    }

    static GraphQLDirective.Builder createDescriptionDirectiveBuilder(String description) {
        GraphQLDirective.Builder descrDirectiveBuilder = GraphQLDirective.newDirective().name(DESCRIPTION);
        GraphQLArgument.Builder descriptionArgumentBuilder = GraphQlTypeUtil.newArgument("_", (GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString));
        if (null != description) {
            descriptionArgumentBuilder.value((Object)description);
        }
        descrDirectiveBuilder.argument(descriptionArgumentBuilder);
        return descrDirectiveBuilder;
    }

    static GraphQLDirective createNameAliasDirective(boolean schemaDefinition) {
        GraphQLDirective.Builder nameAliasDirectiveBuilder = GraphQLDirective.newDirective().name("nameAlias");
        if (schemaDefinition) {
            nameAliasDirectiveBuilder.validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION);
            nameAliasDirectiveBuilder.validLocation(Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION);
        }
        return nameAliasDirectiveBuilder.build();
    }

    static GraphQLDirective createConstraintsDirectiveDefinition() {
        GraphQLDirective.Builder constraintDirective = DirectivesBuilder.createConstraintDirective();
        constraintDirective.validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION);
        constraintDirective.argument(GraphQlFieldArgumentBuilder.minCount());
        constraintDirective.argument(GraphQlFieldArgumentBuilder.maxCount());
        constraintDirective.argument(GraphQlFieldArgumentBuilder.minLength());
        constraintDirective.argument(GraphQlFieldArgumentBuilder.maxLength());
        constraintDirective.argument(GraphQlFieldArgumentBuilder.minInclusive());
        constraintDirective.argument(GraphQlFieldArgumentBuilder.maxInclusive());
        constraintDirective.argument(GraphQlFieldArgumentBuilder.minExclusive());
        constraintDirective.argument(GraphQlFieldArgumentBuilder.maxExclusive());
        constraintDirective.argument(GraphQlFieldArgumentBuilder.valuesIn());
        constraintDirective.argument(GraphQlFieldArgumentBuilder.valuesListExclusive());
        return constraintDirective.build();
    }

    static GraphQLAppliedDirective createConstraintsDirective(PropertyShape propShape) {
        GraphQLAppliedDirective.Builder constraintDirective = (GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("constraints");
        int minValue = (Integer)ObjectsUtil.getOrDefault((Object)propShape.getMin(), (Object)0);
        constraintDirective.argument(GraphQlFieldArgumentBuilder.minCount().value((Object)minValue).build().toAppliedArgument());
        if (propShape.getMax() != null && !"inf".equalsIgnoreCase(propShape.getMax())) {
            int maxValue = Integer.parseInt(propShape.getMax());
            constraintDirective.argument(GraphQlFieldArgumentBuilder.maxCount().value((Object)maxValue).build().toAppliedArgument());
        }
        if (propShape.getValuesIn() != null && !propShape.getValuesIn().isEmpty()) {
            constraintDirective.argument(GraphQlFieldArgumentBuilder.valuesIn().value((Object)propShape.getValuesIn().toString()).build().toAppliedArgument());
        }
        if (Boolean.TRUE.equals(propShape.isValuesListExclusive())) {
            constraintDirective.argument(GraphQlFieldArgumentBuilder.valuesListExclusive().value((Object)true).build().toAppliedArgument());
        }
        Function<Object, Consumer> builder = value -> {
            if (value != null) {
                return argumentSupplier -> {
                    GraphQLArgument.Builder argBuilder = (GraphQLArgument.Builder)argumentSupplier.get();
                    constraintDirective.argument(argBuilder.value(value).build().toAppliedArgument());
                };
            }
            return noOp -> {};
        };
        builder.apply(propShape.getMinLength()).accept(GraphQlFieldArgumentBuilder::minLength);
        builder.apply(propShape.getMaxLength()).accept(GraphQlFieldArgumentBuilder::maxLength);
        builder.apply(propShape.getMinInclusive()).accept(GraphQlFieldArgumentBuilder::minInclusive);
        builder.apply(propShape.getMaxInclusive()).accept(GraphQlFieldArgumentBuilder::maxInclusive);
        builder.apply(propShape.getMinExclusive()).accept(GraphQlFieldArgumentBuilder::minExclusive);
        builder.apply(propShape.getMaxExclusive()).accept(GraphQlFieldArgumentBuilder::maxExclusive);
        return constraintDirective.build();
    }

    static GraphQLDirective createMetaDirective(Map<String, Object> metadata) {
        GraphQLDirective.Builder directiveBuilder = GraphQLDirective.newDirective().name("meta");
        if (metadata == null) {
            directiveBuilder.validLocation(Introspection.DirectiveLocation.OBJECT);
            directiveBuilder.validLocation(Introspection.DirectiveLocation.INTERFACE);
            directiveBuilder.validLocation(Introspection.DirectiveLocation.UNION);
            directiveBuilder.validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION);
            directiveBuilder.argument(GraphQlFieldArgumentBuilder.metaValue());
        } else if (!metadata.isEmpty()) {
            String jsonValue;
            try {
                jsonValue = JsonUtils.toString(metadata);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Meta value is not valid!. Expected simple map got: " + String.valueOf(metadata), ioe);
            }
            directiveBuilder.argument(GraphQlFieldArgumentBuilder.metaValue().valueProgrammatic((Object)jsonValue));
        }
        return directiveBuilder.build();
    }

    private static GraphQLDirective.Builder createConstraintDirective() {
        return GraphQLDirective.newDirective().name("constraints").description("Constraints on semantic object properties.");
    }

    static GraphQLDirective.Builder createSomlTypeDirective() {
        return GraphQLDirective.newDirective().name("somlType").validLocation(Introspection.DirectiveLocation.OBJECT).validLocation(Introspection.DirectiveLocation.INTERFACE).validLocation(Introspection.DirectiveLocation.UNION).argument(GraphQlTypeUtil.newArgument("id", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("inherits", (GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString))).argument(GraphQlTypeUtil.newArgument("kind", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("type", (GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString))).argument(GraphQlTypeUtil.newArgument("typeProp", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("unionOf", (GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString))).argument(GraphQlTypeUtil.newArgument("typePropIri", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("name", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("nameIri", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("label", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument(DESCRIPTION, (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("sparqlFederatedService", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("access", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("regex", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("regexFlags", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("prefix", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("pattern", (GraphQLInputType)Scalars.GraphQLString));
    }

    static GraphQLAppliedDirective.Builder createSomlPropertyDirectiveForType(Shape shape) {
        GraphQLAppliedDirective.Builder somlType = (GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("somlType");
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "id", (GraphQLInputType)Scalars.GraphQLString, shape.getId());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "inherits", (GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString), shape.getInheritsAsList());
        if (shape.isTracked("kind")) {
            DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "kind", (GraphQLInputType)Scalars.GraphQLString, shape.getKind());
        }
        if (shape.isUnion()) {
            DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "unionOf", (GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString), shape.getUnionOfShapes().stream().map(Shape::getId).collect(Collectors.toList()));
        }
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "type", (GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString), shape.getTypeAsList());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "typeProp", (GraphQLInputType)Scalars.GraphQLString, shape.getTypeProp());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "typePropIri", (GraphQLInputType)Scalars.GraphQLString, shape.getTypePropIri());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "name", (GraphQLInputType)Scalars.GraphQLString, shape.getName());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "nameIri", (GraphQLInputType)Scalars.GraphQLString, shape.getNameIri());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "label", (GraphQLInputType)Scalars.GraphQLString, shape.getLabel());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), DESCRIPTION, (GraphQLInputType)Scalars.GraphQLString, shape.getDescr());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "sparqlFederatedService", (GraphQLInputType)Scalars.GraphQLString, shape.getSparqlFederatedService());
        if (shape.isTracked("access")) {
            DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "access", (GraphQLInputType)Scalars.GraphQLString, shape.getAccess());
        }
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "regex", (GraphQLInputType)Scalars.GraphQLString, shape.getRegex());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "regexFlags", (GraphQLInputType)Scalars.GraphQLString, shape.getRegexFlags());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "prefix", (GraphQLInputType)Scalars.GraphQLString, shape.getPrefix());
        if (shape.isTracked("pattern")) {
            DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlType).argument(arg_0), "pattern", (GraphQLInputType)Scalars.GraphQLString, shape.getPattern());
        }
        return somlType;
    }

    static GraphQLDirective.Builder createSomlPropertyDirective() {
        return GraphQLDirective.newDirective().name("somlProperty").validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION).argument(GraphQlTypeUtil.newArgument("name", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("label", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument(DESCRIPTION, (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("rdfProp", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("inverseAlias", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("inverseOf", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("range", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("min", (GraphQLInputType)Scalars.GraphQLInt)).argument(GraphQlTypeUtil.newArgument("max", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("gen", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("restrictive", (GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQlTypeUtil.newArgument("prefix", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("pattern", (GraphQLInputType)Scalars.GraphQLString));
    }

    static GraphQLAppliedDirective.Builder createSomlPropertyDirectiveForProperty(PropertyShape property) {
        GraphQLAppliedDirective.Builder somlProperty = (GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("somlProperty");
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "name", (GraphQLInputType)Scalars.GraphQLString, property.getName());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "rdfProp", (GraphQLInputType)Scalars.GraphQLString, property.getRdfProperty());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "label", (GraphQLInputType)Scalars.GraphQLString, property.getLabel());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), DESCRIPTION, (GraphQLInputType)Scalars.GraphQLString, property.getDescr());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "inverseAlias", (GraphQLInputType)Scalars.GraphQLString, property.getInverseAlias());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "inverseOf", (GraphQLInputType)Scalars.GraphQLString, property.getInverseOf());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "range", (GraphQLInputType)Scalars.GraphQLString, property.getRange());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "min", (GraphQLInputType)Scalars.GraphQLInt, property.getMin());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "max", (GraphQLInputType)Scalars.GraphQLString, property.getMax());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "gen", (GraphQLInputType)Scalars.GraphQLString, property.getGen());
        if (property.isTracked("restrictive")) {
            DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "restrictive", (GraphQLInputType)Scalars.GraphQLBoolean, property.isRestrictive());
        }
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "prefix", (GraphQLInputType)Scalars.GraphQLString, property.getPrefix());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)somlProperty).argument(arg_0), "pattern", (GraphQLInputType)Scalars.GraphQLString, property.getPatternString());
        return somlProperty;
    }

    static GraphQLInputObjectType.Builder createPrefixInput() {
        return GraphQLInputObjectType.newInputObject().name(PREFIX).field(GraphQLInputObjectField.newInputObjectField().name("prefix").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("namespace").type((GraphQLInputType)Scalars.GraphQLString));
    }

    static GraphQLDirective.Builder createPrefixesDirective() {
        return GraphQLDirective.newDirective().name("_Prefixes").validLocation(Introspection.DirectiveLocation.SCHEMA).argument(GraphQlTypeUtil.newArgument(VALUES, (GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(PREFIX))).argument(GraphQlTypeUtil.newArgument("base_iri", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("ontology_iri", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("vocab_iri", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("vocab_prefix", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("shape_iri", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("shape_prefix", (GraphQLInputType)Scalars.GraphQLString));
    }

    static GraphQLAppliedDirective.Builder createPrefixesDirective(SomlSchema schema) {
        GraphQLAppliedDirective.Builder builder = (GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("_Prefixes");
        SpecialPrefixes specialPrefixes = schema.getSpecialPrefixes();
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "base_iri", (GraphQLInputType)Scalars.GraphQLString, specialPrefixes.getBaseIri().orElse(null));
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "ontology_iri", (GraphQLInputType)Scalars.GraphQLString, specialPrefixes.getOntologyIri().orElse(null));
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "vocab_iri", (GraphQLInputType)Scalars.GraphQLString, specialPrefixes.getVocabIri().orElse(null));
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "vocab_prefix", (GraphQLInputType)Scalars.GraphQLString, specialPrefixes.getVocabPrefix().orElse(null));
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "shape_iri", (GraphQLInputType)Scalars.GraphQLString, specialPrefixes.getShapeIri().orElse(null));
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "shape_prefix", (GraphQLInputType)Scalars.GraphQLString, specialPrefixes.getShapePrefix().orElse(null));
        List prefixes = schema.getPrefixes().entrySet().stream().map(entry -> Map.of("prefix", (String)entry.getKey(), "namespace", (String)entry.getValue())).collect(Collectors.toList());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), VALUES, (GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(PREFIX), prefixes);
        return builder;
    }

    static GraphQLInputObjectType.Builder createConfigInput() {
        return GraphQLInputObjectType.newInputObject().name(CONFIG).field(GraphQLInputObjectField.newInputObjectField().name("key").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("value").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("type").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("defaultValue").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name(DESCRIPTION).type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("possibleValues").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)));
    }

    static GraphQLDirective.Builder createConfigDirective() {
        return GraphQLDirective.newDirective().name("_Configs").validLocation(Introspection.DirectiveLocation.SCHEMA).argument(GraphQlTypeUtil.newArgument(VALUES, (GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(CONFIG)));
    }

    static GraphQLAppliedDirective.Builder createConfigDirective(SomlSchema schema) {
        GraphQLAppliedDirective.Builder builder = (GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("_Configs");
        Configs configs = schema.getConfig();
        List config = Configs.getConfigInfo().values().stream().map(value -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("key", value.name());
            map.put("value", configs.get((Object)value.name()));
            map.put("type", value.type());
            Object defaultValue = value.defaultValue();
            if (defaultValue != null) {
                map.put("defaultValue", defaultValue);
            }
            map.put(DESCRIPTION, value.description());
            List possibleValues = value.possibleValues();
            if (possibleValues != null && !possibleValues.isEmpty()) {
                map.put("possibleValues", possibleValues);
            }
            return map;
        }).collect(Collectors.toList());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), VALUES, (GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(CONFIG), config);
        return builder;
    }

    static GraphQLDirective.Builder createSomlInfoDirective() {
        return GraphQLDirective.newDirective().name("_SomlInfo").validLocation(Introspection.DirectiveLocation.SCHEMA).argument(GraphQlTypeUtil.newArgument("id", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("label", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("license", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("created", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("updated", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("creator", (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument("versionInfo", (GraphQLInputType)Scalars.GraphQLString));
    }

    static GraphQLAppliedDirective.Builder createSomlInfoDirective(SomlSchema schema) {
        GraphQLAppliedDirective.Builder builder = (GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("_SomlInfo");
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "id", (GraphQLInputType)Scalars.GraphQLString, schema.getId());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "label", (GraphQLInputType)Scalars.GraphQLString, schema.getLabel());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "license", (GraphQLInputType)Scalars.GraphQLString, schema.getLicense());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "created", (GraphQLInputType)Scalars.GraphQLString, schema.getCreated());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "updated", (GraphQLInputType)Scalars.GraphQLString, schema.getUpdated());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "creator", (GraphQLInputType)Scalars.GraphQLString, schema.getCreator());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "versionInfo", (GraphQLInputType)Scalars.GraphQLString, schema.getVersionInfo());
        return builder;
    }

    static GraphQLInputObjectType.Builder createRbacRoleInput() {
        return GraphQLInputObjectType.newInputObject().name(RBAC_ROLE).field(GraphQLInputObjectField.newInputObjectField().name("name").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name(DESCRIPTION).type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("actions").type((GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(RBAC_ROLE_ACTION))).field(GraphQLInputObjectField.newInputObjectField().name("notActions").type((GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(RBAC_ROLE_ACTION)));
    }

    static GraphQLInputObjectType.Builder createRbacRoleActionInput() {
        return GraphQLInputObjectType.newInputObject().name(RBAC_ROLE_ACTION).field(GraphQLInputObjectField.newInputObjectField().name("object").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("property").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("action").type((GraphQLInputType)Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("filter").type((GraphQLInputType)Scalars.GraphQLString));
    }

    static GraphQLDirective.Builder createRbacDirective() {
        return GraphQLDirective.newDirective().name("_Rbac").validLocation(Introspection.DirectiveLocation.SCHEMA).argument(GraphQlTypeUtil.newArgument("roles", (GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(RBAC_ROLE)));
    }

    static GraphQLAppliedDirective.Builder createRbacDirective(SomlSchema schema) {
        GraphQLAppliedDirective.Builder builder = (GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("_Rbac");
        List roles = schema.getRbac().getRoles().entrySet().stream().map(entry -> {
            List notActions;
            List actions;
            Role value = (Role)entry.getValue();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", entry.getKey());
            String description = value.getDescription();
            if (description != null) {
                map.put(DESCRIPTION, description);
            }
            if ((actions = value.getActions()) != null && !actions.isEmpty()) {
                map.put("actions", DirectivesBuilder.createMapOfActions(actions));
            }
            if ((notActions = value.getNotActions()) != null && !notActions.isEmpty()) {
                map.put("notActions", DirectivesBuilder.createMapOfActions(notActions));
            }
            return map;
        }).collect(Collectors.toList());
        DirectivesBuilder.newArgument(arg_0 -> ((GraphQLAppliedDirective.Builder)builder).argument(arg_0), "roles", (GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(RBAC_ROLE), roles);
        return builder;
    }

    private static Map<String, Object> createMapOfActions(List<RoleAction> actions) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        actions.forEach(action -> {
            map.put("object", ObjectsUtil.getOrDefault((Object)action.getObject(), (Object)"*"));
            map.put("property", ObjectsUtil.getOrDefault((Object)action.getProperty(), (Object)"*"));
            map.put("action", ObjectsUtil.getOrDefault((Object)action.getAction(), (Object)"*"));
            String filter = action.getFilter();
            if (filter != null) {
                map.put("filter", filter);
            }
        });
        return map;
    }

    private static void newArgument(Consumer<GraphQLAppliedDirectiveArgument> directiveConsumer, String name, GraphQLInputType type, Object value) {
        if (!(value == null || value instanceof Collection && ((Collection)value).isEmpty())) {
            directiveConsumer.accept(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(name)).type(type).valueProgrammatic(value).build());
        }
    }
}

