/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.jmx.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.monitor.common.MonitoringMBeanUtils;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.impex.ExecutorProvider;
import com.ontotext.forest.jmx.domain.ClusterStatisticsBean;
import com.ontotext.forest.jmx.domain.GlobalPageCacheStatistics;
import com.ontotext.forest.jmx.domain.backup.BackupOperationBean;
import com.ontotext.forest.jmx.domain.infrastructure.ResourceUsage;
import com.ontotext.forest.jmx.domain.infrastructure.StorageMemory;
import com.ontotext.forest.jmx.domain.operations.ActiveOperation;
import com.ontotext.forest.jmx.domain.operations.ActiveOperationsResultBean;
import com.ontotext.forest.jmx.domain.operations.OperationStatus;
import com.ontotext.forest.jmx.domain.repository.EntityPoolStatistics;
import com.ontotext.forest.jmx.domain.repository.QueryStatistics;
import com.ontotext.forest.jmx.domain.repository.RepositoryMonitorStatisticsBean;
import com.ontotext.forest.jmx.domain.repository.RepositoryMonitorTrackRecordBean;
import com.ontotext.forest.jmx.formatter.PrometheusFormatField;
import com.ontotext.forest.recovery.BackupOperationStatus;
import com.ontotext.forest.recovery.RecoveryService;
import com.ontotext.forest.repositories.RepositoryUtils;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.raft.grpc.StatusResponse;
import com.ontotext.graphdb.recovery.SnapshotOptions;
import com.ontotext.graphdb.security.Role;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.trree.RepositoryMonitorTrackRecord;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MonitoringService {
    private final SemanticDataManagement dataManagement;
    private final RecoveryService recoveryService;
    private final ExecutorProvider executorProvider;

    public MonitoringService(SemanticDataManagement dataManagement, RecoveryService recoveryService, ExecutorProvider executorProvider) {
        this.dataManagement = dataManagement;
        this.recoveryService = recoveryService;
        this.executorProvider = executorProvider;
    }

    public List<RepositoryMonitorTrackRecordBean> getActiveQueries(String repositoryID, SemanticLocation semanticLocation) throws ReflectionException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        SemanticRepository semanticRepository = this.initializeRepoIfExist(semanticLocation, repositoryID, true);
        if (!RepositoryUtils.isOntopRepository((SemanticRepository)semanticRepository, (SemanticLocation)semanticLocation)) {
            CompositeData[] trackRecords = (CompositeData[])MonitoringMBeanUtils.invokeMethodWithMBean((String)repositoryID, (String)"TrackRecords");
            LinkedList<RepositoryMonitorTrackRecordBean> queries = new LinkedList<RepositoryMonitorTrackRecordBean>();
            for (CompositeData compositeData : trackRecords) {
                RepositoryMonitorTrackRecordBean repositoryMonitorTrackRecordBean = new RepositoryMonitorTrackRecordBean();
                repositoryMonitorTrackRecordBean.fillCompositeData(compositeData);
                queries.add(repositoryMonitorTrackRecordBean);
            }
            return queries;
        }
        return Collections.emptyList();
    }

    public Integer getQueriesCount(String repositoryID, SemanticLocation semanticLocation) throws ReflectionException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        this.initializeRepoIfExist(semanticLocation, repositoryID, true);
        return (Integer)MonitoringMBeanUtils.invokeMethodWithMBean((String)repositoryID, (String)"TrackRecordsNumber");
    }

    public void deleteQuery(String repositoryID, String query, SemanticLocation semanticLocation) throws ReflectionException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        String requestStopById;
        this.initializeRepoIfExist(semanticLocation, repositoryID, false);
        Object requestStopByAlias = MonitoringMBeanUtils.invokeMethodWithMBean((String)repositoryID, (String)"requestStopByAlias", (String)query);
        if (!Boolean.parseBoolean(requestStopByAlias.toString()) && !Boolean.parseBoolean(requestStopById = MonitoringMBeanUtils.invokeMethodWithMBean((String)repositoryID, (String)"requestStop", (String)query).toString())) {
            throw new GraphDBWorkbenchException("Query or update not found. It might have already expired.");
        }
    }

    public String getQuery(String repositoryID, String query, SemanticLocation semanticLocation) throws ReflectionException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        this.initializeRepoIfExist(semanticLocation, repositoryID, false);
        String queryString = (String)MonitoringMBeanUtils.invokeMethodWithMBean((String)repositoryID, (String)"getFullSparqlString", (String)query);
        if (StringUtils.isEmpty((CharSequence)queryString) || "# Operation expired".equals(queryString)) {
            throw new GraphDBWorkbenchException("Query or update not found. It might have already expired.");
        }
        return queryString;
    }

    public ResponseEntity<?> getRepositoryStatistics(HttpServletRequest request, String repositoryID, SemanticLocation semanticLocation) throws ReflectionException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        SemanticRepository semanticRepository = this.initializeRepoIfExist(semanticLocation, repositoryID, true);
        String repositoryType = "";
        if (RepositoryUtils.isOntopRepository((SemanticRepository)semanticRepository, (SemanticLocation)semanticLocation)) {
            repositoryType = "Ontop";
        } else if (RepositoryUtils.isFedXRepository((SemanticRepository)semanticRepository, (SemanticLocation)semanticLocation)) {
            repositoryType = "Fedx";
        }
        if (repositoryType.isEmpty()) {
            RepositoryMonitorStatisticsBean repositoryMonitorStatisticsBean = new RepositoryMonitorStatisticsBean();
            repositoryMonitorStatisticsBean.setQueries(new QueryStatistics((Long)MonitoringMBeanUtils.invokeMethodWithMBean((String)repositoryID, (String)"SlowQueries"), (Long)MonitoringMBeanUtils.invokeMethodWithMBean((String)repositoryID, (String)"SuboptimalQueries")));
            repositoryMonitorStatisticsBean.setActiveTransactions((Long)MonitoringMBeanUtils.invokeMethodWithMBean((String)repositoryID, (String)"ActiveTransactions"));
            repositoryMonitorStatisticsBean.setOpenConnections((Long)MonitoringMBeanUtils.invokeMethodWithMBean((String)repositoryID, (String)"OpenConnections"));
            repositoryMonitorStatisticsBean.setEntityPool(new EntityPoolStatistics((Long)MonitoringMBeanUtils.getCountAttributeFromMBean((String)repositoryID, (String)"epool.read"), (Long)MonitoringMBeanUtils.getCountAttributeFromMBean((String)repositoryID, (String)"epool.write"), (Long)MonitoringMBeanUtils.getCountAttributeFromMBean((String)repositoryID, (String)"epool.size")));
            if (this.shouldReturnPrometheusFormat(request)) {
                return new ResponseEntity((Object)repositoryMonitorStatisticsBean.fillPrometheusData(), (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((Object)repositoryMonitorStatisticsBean, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)(repositoryType + " repositories doesn't support statistics"), (HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    public ResponseEntity<?> getStructuresStatistics(HttpServletRequest request) throws ReflectionException, MalformedObjectNameException, AttributeNotFoundException, MBeanException {
        GlobalPageCacheStatistics cacheStatistics = new GlobalPageCacheStatistics();
        try {
            cacheStatistics.setCacheHit((Long)MonitoringMBeanUtils.getCountAttributeFromMBean((String)"cache.hit"));
            cacheStatistics.setCacheMiss((Long)MonitoringMBeanUtils.getCountAttributeFromMBean((String)"cache.miss"));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        if (this.shouldReturnPrometheusFormat(request)) {
            return new ResponseEntity((Object)cacheStatistics.fillPrometheusData(), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)cacheStatistics, (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<?> getInfrastructureStatistics(HttpServletRequest request) {
        StorageMemory storageMemory = new StorageMemory();
        storageMemory.calculateDataDirMemory();
        storageMemory.calculateWorkDirMemory();
        storageMemory.calculateLogsDirMemory();
        ResourceUsage resourceUsage = new ResourceUsage();
        resourceUsage.getMemoryUsageFromMXBean();
        resourceUsage.getThreadCountFromMXBean();
        resourceUsage.getCpuLoadFromMXBean();
        resourceUsage.getClassCountFromMXBean();
        resourceUsage.getGcCountFromMXBean();
        resourceUsage.setStorageMemory(storageMemory);
        resourceUsage.getFileDescriptorsFromMXBean();
        if (this.shouldReturnPrometheusFormat(request)) {
            return new ResponseEntity((Object)resourceUsage.fillPrometheusData(), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)resourceUsage, (HttpStatusCode)HttpStatus.OK);
    }

    public SemanticLocation getSemanticLocation() {
        return this.dataManagement.getLocationFromHeaderOrThrow();
    }

    public boolean shouldReturnPrometheusFormat(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader == null) {
            return true;
        }
        return !acceptHeader.contains("application/json");
    }

    public boolean shouldReturnEmptyResult(SemanticLocation semanticLocation, String repositoryID) {
        this.checkIfRepositoryExists(semanticLocation, repositoryID);
        return !semanticLocation.getRepository(repositoryID).getRepository().isInitialized();
    }

    private SemanticRepository initializeRepoIfExist(SemanticLocation semanticLocation, String repositoryID, boolean shouldForceInitRepo) {
        this.checkIfRepositoryExists(semanticLocation, repositoryID);
        SemanticRepository semanticRepository = semanticLocation.getRepository(repositoryID);
        if (!shouldForceInitRepo && !semanticRepository.getRepository().isInitialized()) {
            throw new GraphDBWorkbenchException("Repository " + repositoryID + " is not initialised yet.");
        }
        if (!semanticRepository.isLocal()) {
            try (RepositoryConnection connection = semanticRepository.getConnection();){
                connection.size(new Resource[0]);
            }
        }
        return semanticRepository;
    }

    private void checkIfRepositoryExists(SemanticLocation semanticLocation, String repositoryID) {
        if (!semanticLocation.containsRepository(repositoryID)) {
            throw new GraphDBWorkbenchException("Repository " + repositoryID + " doesn't exist.");
        }
    }

    public ClusterStatisticsBean getClusterStatisticsBean() {
        ClusterStatisticsBean clusterStatisticsBean = new ClusterStatisticsBean();
        clusterStatisticsBean.fillCompositeData(this.dataManagement.getCurrentLocationOrThrow().getReplicationClusterOrThrow().getClusterStatistics());
        return clusterStatisticsBean;
    }

    public String getClusterStatisticsString() {
        HashMap<PrometheusFormatField, Object> metrics = new HashMap<PrometheusFormatField, Object>();
        ClusterStatisticsBean clusterStatisticsBean = new ClusterStatisticsBean();
        clusterStatisticsBean.fillCompositeData(this.dataManagement.getCurrentLocationOrThrow().getReplicationClusterOrThrow().getClusterStatistics());
        metrics.put(PrometheusFormatField.CLUSTER_LEADER_ELECTIONS_COUNT, clusterStatisticsBean.getTerm());
        metrics.put(PrometheusFormatField.CLUSTER_FAILURE_RECOVERIES_COUNT, clusterStatisticsBean.getFailureRecoveriesCount());
        metrics.put(PrometheusFormatField.CLUSTER_FAILED_TRANSACTIONS_COUNT, clusterStatisticsBean.getFailedTransactionsCount());
        metrics.put(PrometheusFormatField.CLUSTER_TOTAL_NODES, clusterStatisticsBean.getNodesInCluster());
        metrics.put(PrometheusFormatField.CLUSTER_NODES_IN_SYNC, clusterStatisticsBean.getNodesInSync());
        metrics.put(PrometheusFormatField.CLUSTER_NODES_OUT_OF_SYNC, clusterStatisticsBean.getNodesOutOfSync());
        metrics.put(PrometheusFormatField.CLUSTER_NODES_DISCONNECTED, clusterStatisticsBean.getNodesDisconnected());
        metrics.put(PrometheusFormatField.CLUSTER_NODES_SYNCING, clusterStatisticsBean.getNodesSyncing());
        return PrometheusFormatField.parse(metrics);
    }

    public Object getBackupRecoveryOperation() {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode emptyJson = objectMapper.createObjectNode();
        BackupOperationStatus backupOperationStatus = this.recoveryService.getBackupOperationStatus();
        if (backupOperationStatus == null) {
            return emptyJson;
        }
        BackupOperationStatus.BackupOperationInProgress backupOperationInProgress = backupOperationStatus.getOperation();
        if (backupOperationInProgress == null) {
            return emptyJson;
        }
        SnapshotOptions snapshotOptions = backupOperationStatus.getSnapshotOptions();
        Set affectedRepos = this.recoveryService.resolveAffectedRepositories(backupOperationInProgress, snapshotOptions);
        return new BackupOperationBean(backupOperationStatus, affectedRepos);
    }

    public String getBackupRecoveryOperationString() {
        HashMap<PrometheusFormatField, Object> metrics = new HashMap<PrometheusFormatField, Object>();
        Object backupOperationBean = this.getBackupRecoveryOperation();
        BackupOperationStatus backupOperationStatus = this.recoveryService.getBackupOperationStatus();
        if (backupOperationBean instanceof BackupOperationBean) {
            BackupOperationStatus.BackupOperationInProgress backupOperationInProgress = ((BackupOperationBean)backupOperationBean).getOperation();
            if (backupOperationInProgress.equals((Object)BackupOperationStatus.BackupOperationInProgress.CREATE_BACKUP_IN_PROGRESS) || backupOperationInProgress.equals((Object)BackupOperationStatus.BackupOperationInProgress.CREATE_CLOUD_BACKUP_IN_PROGRESS)) {
                metrics.put(PrometheusFormatField.BACKUP_OPERATION_CREATING, backupOperationStatus.getIdCreatingBackupOperation());
            }
            if (backupOperationInProgress.equals((Object)BackupOperationStatus.BackupOperationInProgress.RESTORE_BACKUP_IN_PROGRESS) || backupOperationInProgress.equals((Object)BackupOperationStatus.BackupOperationInProgress.RESTORE_CLOUD_BACKUP_IN_PROGRESS)) {
                metrics.put(PrometheusFormatField.BACKUP_OPERATION_RESTORING, backupOperationStatus.getIdRestoringBackupOperation());
            }
            return PrometheusFormatField.parse(metrics);
        }
        return "0";
    }

    public ActiveOperationsResultBean getActiveOperationsBean(String repositoryId) throws ReflectionException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        ArrayList<ActiveOperation> activeOperations = new ArrayList<ActiveOperation>();
        SemanticLocation location = this.getSemanticLocation();
        this.putQueriesAndUpdateOperations(repositoryId, location, activeOperations);
        this.putActiveImportsOperations(repositoryId, activeOperations);
        this.putBackupAndRestoreOperation(activeOperations);
        this.putClusterHealthOperations(location, activeOperations);
        if (activeOperations.isEmpty()) {
            return new ActiveOperationsResultBean();
        }
        return new ActiveOperationsResultBean(this.calculateStatus(activeOperations), activeOperations);
    }

    private void putClusterHealthOperations(SemanticLocation location, List<ActiveOperation> activeOperations) {
        if (location.getClusterConfigService().isClusterEnabled()) {
            GraphDBReplicationCluster replicationCluster = location.getReplicationClusterOrThrow();
            Map groupStatus = replicationCluster.getGroupStatus();
            if (!location.getReplicationClusterOrThrow().isWritable()) {
                activeOperations.add(new ActiveOperation(ActiveOperation.OperationType.CLUSTER_STATUS, ActiveOperation.ClusterStatus.OUT_OF_SYNC));
            } else if (this.isRunningRecovery(groupStatus)) {
                activeOperations.add(new ActiveOperation(ActiveOperation.OperationType.CLUSTER_STATUS, ActiveOperation.ClusterStatus.RECOVERING));
            } else if (!replicationCluster.areAllNodesAvailable()) {
                activeOperations.add(new ActiveOperation(ActiveOperation.OperationType.CLUSTER_STATUS, ActiveOperation.ClusterStatus.UNAVAILABLE_NODES));
            } else {
                activeOperations.add(new ActiveOperation(ActiveOperation.OperationType.CLUSTER_STATUS, ActiveOperation.ClusterStatus.IN_SYNC));
            }
        }
    }

    private void putBackupAndRestoreOperation(List<ActiveOperation> activeOperations) {
        if (this.userHasMonitoringRights()) {
            boolean isRunningBackupAndRestore;
            boolean bl = isRunningBackupAndRestore = this.recoveryService.getBackupOperationStatus() != null && this.recoveryService.getBackupOperationStatus().getOperation() != null;
            if (isRunningBackupAndRestore) {
                activeOperations.add(new ActiveOperation(this.recoveryService.getBackupOperationStatus().getOperation()));
            }
        }
    }

    @VisibleForTesting
    protected boolean userHasMonitoringRights() {
        return GraphDBHTTPContext.getAuthenticatedUser().hasRole(Role.ROLE_MONITORING.name());
    }

    private void putActiveImportsOperations(String repositoryId, List<ActiveOperation> activeOperations) {
        long numberOfImports = this.executorProvider.getNumberOfTasks(repositoryId);
        if (numberOfImports > 0L) {
            activeOperations.add(new ActiveOperation(ActiveOperation.OperationType.IMPORTS, numberOfImports));
        }
    }

    private void putQueriesAndUpdateOperations(String repositoryId, SemanticLocation location, List<ActiveOperation> activeOperations) throws ReflectionException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        long countActiveQueries = 0L;
        long countActiveUpdates = 0L;
        List<RepositoryMonitorTrackRecordBean> activeQueries = this.getActiveQueries(repositoryId, location);
        for (RepositoryMonitorTrackRecordBean record : activeQueries) {
            if (record.getType() == RepositoryMonitorTrackRecord.Type.UPDATE) {
                ++countActiveUpdates;
                continue;
            }
            ++countActiveQueries;
        }
        if (countActiveQueries != 0L) {
            activeOperations.add(new ActiveOperation(ActiveOperation.OperationType.QUERIES, countActiveQueries));
        }
        if (countActiveUpdates != 0L) {
            activeOperations.add(new ActiveOperation(ActiveOperation.OperationType.UPDATES, countActiveUpdates));
        }
    }

    private OperationStatus calculateStatus(List<ActiveOperation> activeOperations) {
        OperationStatus resultStatus = OperationStatus.INFORMATION;
        for (ActiveOperation operation : activeOperations) {
            if (resultStatus == OperationStatus.INFORMATION && (operation.getStatus() == OperationStatus.WARNING || operation.getStatus() == OperationStatus.CRITICAL)) {
                resultStatus = operation.getStatus();
                continue;
            }
            if (resultStatus != OperationStatus.WARNING || operation.getStatus() != OperationStatus.CRITICAL) continue;
            resultStatus = OperationStatus.CRITICAL;
        }
        return resultStatus;
    }

    private boolean isRunningRecovery(Map<String, StatusResponse> groupStatus) {
        return groupStatus.values().stream().anyMatch(value -> StringUtils.isNotEmpty((CharSequence)value.getRecoveryState().getRecoveryOperationMessage()));
    }
}

