/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.jmx.formatter;

import com.ontotext.forest.jmx.formatter.PrometheusMetricType;
import java.util.Map;

public enum PrometheusFormatField {
    SLOW_QUERIES("graphdb_slow_queries_count", PrometheusMetricType.COUNTER, "Count of slow queries executed on the repository."),
    SUBOPTIMAL_QUERIES("graphdb_suboptimal_queries_count", PrometheusMetricType.COUNTER, "Count of queries that the GraphDB engine was not able to evaluate and were sent for evaluation to the RDF4J engine."),
    ACTIVE_TRANSACTIONS("graphdb_active_transactions", PrometheusMetricType.GAUGE, "Count of currently active transactions."),
    OPEN_CONNECTIONS("graphdb_open_connections", PrometheusMetricType.GAUGE, "Count of currently open connections."),
    OPEN_FILE_DESCRIPTORS("graphdb_open_file_descriptors", PrometheusMetricType.GAUGE, "Count of currently open file descriptors."),
    MAX_FILE_DESCRIPTORS("graphdb_max_file_descriptors", PrometheusMetricType.GAUGE, "Maximum available file descriptors."),
    CLASS_COUNT("graphdb_class_count", PrometheusMetricType.GAUGE, "Count of the number of classes that are currently loaded in the Java virtual machine."),
    CPU_LOAD("graphdb_cpu_load", PrometheusMetricType.GAUGE, "Current CPU load for the entire system in percentage."),
    GC_COUNT("graphdb_mem_garbage_collections_count", PrometheusMetricType.COUNTER, "Count of full garbage collections from the starting of the GraphDB instance."),
    HEAP_MAX("graphdb_heap_max_mem", PrometheusMetricType.GAUGE, "Maximum available memory for the GraphDB instance."),
    HEAP_INIT("graphdb_heap_init_mem", PrometheusMetricType.GAUGE, "Initial amount of memory (controlled by -Xms) in bytes."),
    HEAP_COMMITTED("graphdb_heap_committed_mem", PrometheusMetricType.GAUGE, "Current committed memory in bytes."),
    HEAP_USED("graphdb_heap_used_mem", PrometheusMetricType.GAUGE, "Current used memory in bytes."),
    NONHEAP_MAX("graphdb_nonheap_max_mem", PrometheusMetricType.GAUGE, "Maximum direct memory, returns -1 if undefined."),
    NONHEAP_INIT("graphdb_nonheap_init_mem", PrometheusMetricType.GAUGE, "Off-heap initial memory in bytes."),
    NONHEAP_COMMITTED("graphdb_nonheap_committed_mem", PrometheusMetricType.GAUGE, "Current off-heap committed memory in bytes."),
    NONHEAP_USED("graphdb_nonheap_used_mem", PrometheusMetricType.GAUGE, "Current off-heap used memory in bytes."),
    DATA_DIR_USED("graphdb_data_dir_used", PrometheusMetricType.GAUGE, "Used storage space on the partition where the data directory sits, in bytes."),
    WORK_DIR_USED("graphdb_work_dir_used", PrometheusMetricType.GAUGE, "Used storage space on the partition where the work directory sits, in bytes."),
    LOGS_DIR_USED("graphdb_logs_dir_used", PrometheusMetricType.GAUGE, "Used storage space on the partition where the logs directory sits, in bytes."),
    DATA_DIR_FREE("graphdb_data_dir_free", PrometheusMetricType.GAUGE, "Free storage space on the partition where the data directory sits, in bytes."),
    WORK_DIR_FREE("graphdb_work_dir_free", PrometheusMetricType.GAUGE, "Free storage space on the partition where the work directory sits, in bytes."),
    LOGS_DIR_FREE("graphdb_logs_dir_free", PrometheusMetricType.GAUGE, "Free storage space on the partition where the logs directory sits, in bytes."),
    THREADS_COUNT("graphdb_threads_count", PrometheusMetricType.GAUGE, "Current used threads count."),
    CLUSTER_LEADER_ELECTIONS_COUNT("graphdb_leader_elections_count", PrometheusMetricType.COUNTER, "Count of leader elections from cluster creation."),
    CLUSTER_FAILURE_RECOVERIES_COUNT("graphdb_failure_recoveries_count", PrometheusMetricType.COUNTER, "Count of total failed recoveries in the cluster from cluster creation."),
    CLUSTER_FAILED_TRANSACTIONS_COUNT("graphdb_failed_transactions_count", PrometheusMetricType.COUNTER, "Count of failed transactions in the cluster."),
    CLUSTER_TOTAL_NODES("graphdb_nodes_in_cluster", PrometheusMetricType.GAUGE, "Total nodes count in the cluster."),
    CLUSTER_NODES_IN_SYNC("graphdb_nodes_in_sync", PrometheusMetricType.GAUGE, "Count of nodes that are currently in-sync."),
    CLUSTER_NODES_OUT_OF_SYNC("graphdb_nodes_out_of_sync", PrometheusMetricType.GAUGE, "Count of nodes that are out-of-sync."),
    CLUSTER_NODES_DISCONNECTED("graphdb_nodes_disconnected", PrometheusMetricType.GAUGE, "Count of nodes that are disconnected."),
    CLUSTER_NODES_SYNCING("graphdb_nodes_syncing", PrometheusMetricType.GAUGE, "Count of nodes that are currently syncing."),
    CACHE_HIT("graphdb_cache_hit", PrometheusMetricType.COUNTER, "GraphDB\u2019s global page cache hits count."),
    CACHE_MISS("graphdb_cache_miss", PrometheusMetricType.COUNTER, "GraphDB\u2019s global page cache miss count."),
    ENTITY_POOL_READS("graphdb_entity_pool_reads", PrometheusMetricType.COUNTER, "GraphDB\u2019s entity pool reads count."),
    ENTITY_POOL_WRITES("graphdb_entity_pool_writes", PrometheusMetricType.COUNTER, "GraphDB\u2019s entity pool writes count."),
    EPOOL_SIZE("graphdb_epool_size", PrometheusMetricType.GAUGE, "Current entity pool size, i.e., entity count in the entity pool."),
    BACKUP_OPERATION_CREATING("graphdb_backup_creating_operation", PrometheusMetricType.COUNTER, "The current operation is creating a backup."),
    BACKUP_OPERATION_RESTORING("graphdb_backup_restoring_operation", PrometheusMetricType.COUNTER, "The current operation is restoring from a backup.");

    private final String prometheusField;
    private final String prometheusType;
    private final String prometheusHelp;

    private PrometheusFormatField(String prometheusField, PrometheusMetricType prometheusType, String description) {
        this.prometheusField = prometheusField;
        this.prometheusType = prometheusType.toString().toLowerCase();
        this.prometheusHelp = description;
    }

    public String getPrometheusField() {
        return this.prometheusField;
    }

    public String getPrometheusType() {
        return this.prometheusType;
    }

    public String getPrometheusHelp() {
        return this.prometheusHelp;
    }

    public static String parse(Map<PrometheusFormatField, Object> metrics) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<PrometheusFormatField, Object> metric : metrics.entrySet()) {
            String fieldName = metric.getKey().getPrometheusField();
            stringBuilder.append("# HELP ").append(fieldName).append(" ").append(metric.getKey().getPrometheusHelp()).append(System.getProperty("line.separator"));
            stringBuilder.append("# TYPE ").append(fieldName).append(" ").append(metric.getKey().getPrometheusType()).append(System.getProperty("line.separator"));
            stringBuilder.append(fieldName).append(" ").append(metric.getValue()).append(System.getProperty("line.separator"));
        }
        return stringBuilder.toString();
    }
}

