/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.jmx.domain.infrastructure;

import com.ontotext.forest.jmx.domain.infrastructure.JvmMemory;
import com.ontotext.forest.jmx.domain.infrastructure.StorageMemory;
import com.ontotext.forest.jmx.formatter.PrometheusFormatField;
import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;

@Schema
public class ResourceUsage {
    private JvmMemory heapMemoryUsage;
    private JvmMemory nonHeapMemoryUsage;
    private StorageMemory storageMemory;
    private int threadCount;
    private double cpuLoad;
    private int classCount;
    private long gcCount;
    private long openFileDescriptors;
    private long maxFileDescriptors;

    public JvmMemory getHeapMemoryUsage() {
        return this.heapMemoryUsage;
    }

    public void getMemoryUsageFromMXBean() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        this.heapMemoryUsage = new JvmMemory(heapMemoryUsage.getMax(), heapMemoryUsage.getCommitted(), heapMemoryUsage.getInit(), heapMemoryUsage.getUsed());
        MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
        this.nonHeapMemoryUsage = new JvmMemory(this.calcMaxDirectMemory(), nonHeapMemoryUsage.getCommitted(), nonHeapMemoryUsage.getInit(), nonHeapMemoryUsage.getUsed());
    }

    public void setHeapMemoryUsage(JvmMemory heapMemoryUsage) {
        this.heapMemoryUsage = heapMemoryUsage;
    }

    public JvmMemory getNonHeapMemoryUsage() {
        return this.nonHeapMemoryUsage;
    }

    public void setNonHeapMemoryUsage(JvmMemory nonHeapMemoryUsage) {
        this.nonHeapMemoryUsage = nonHeapMemoryUsage;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void getThreadCountFromMXBean() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        this.threadCount = threadMXBean.getThreadCount();
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public double getCpuLoad() {
        return this.cpuLoad;
    }

    public void getCpuLoadFromMXBean() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.cpuLoad = operatingSystemMXBean.getSystemCpuLoad() * 100.0;
    }

    public void setCpuLoad(double cpuLoad) {
        this.cpuLoad = cpuLoad;
    }

    public int getClassCount() {
        return this.classCount;
    }

    public void getClassCountFromMXBean() {
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        this.classCount = classLoadingMXBean.getLoadedClassCount();
    }

    public void setClassCount(int classCount) {
        this.classCount = classCount;
    }

    public long getGcCount() {
        return this.gcCount;
    }

    public void getGcCountFromMXBean() {
        long gcCount = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long collectionCount = garbageCollectorMXBean.getCollectionCount();
            if (collectionCount < 0L) continue;
            gcCount += collectionCount;
        }
        this.gcCount = gcCount;
    }

    public void setGcCount(long gcCount) {
        this.gcCount = gcCount;
    }

    public StorageMemory getStorageMemory() {
        return this.storageMemory;
    }

    public void setStorageMemory(StorageMemory storageMemory) {
        this.storageMemory = storageMemory;
    }

    public void getFileDescriptorsFromMXBean() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixOSMXBean = (UnixOperatingSystemMXBean)operatingSystemMXBean;
            this.openFileDescriptors = unixOSMXBean.getOpenFileDescriptorCount();
            this.maxFileDescriptors = unixOSMXBean.getMaxFileDescriptorCount();
        }
    }

    public long getOpenFileDescriptors() {
        return this.openFileDescriptors;
    }

    public void setOpenFileDescriptors(long openFileDescriptors) {
        this.openFileDescriptors = openFileDescriptors;
    }

    public long getMaxFileDescriptors() {
        return this.maxFileDescriptors;
    }

    public void setMaxFileDescriptors(long maxFileDescriptors) {
        this.maxFileDescriptors = maxFileDescriptors;
    }

    public String fillPrometheusData() {
        HashMap<PrometheusFormatField, Object> statistics = new HashMap<PrometheusFormatField, Object>();
        statistics.put(PrometheusFormatField.HEAP_MAX, this.heapMemoryUsage.getMax());
        statistics.put(PrometheusFormatField.HEAP_COMMITTED, this.heapMemoryUsage.getCommitted());
        statistics.put(PrometheusFormatField.HEAP_INIT, this.heapMemoryUsage.getInit());
        statistics.put(PrometheusFormatField.HEAP_USED, this.heapMemoryUsage.getUsed());
        statistics.put(PrometheusFormatField.NONHEAP_MAX, this.nonHeapMemoryUsage.getMax());
        statistics.put(PrometheusFormatField.NONHEAP_COMMITTED, this.nonHeapMemoryUsage.getCommitted());
        statistics.put(PrometheusFormatField.NONHEAP_INIT, this.nonHeapMemoryUsage.getInit());
        statistics.put(PrometheusFormatField.NONHEAP_USED, this.nonHeapMemoryUsage.getUsed());
        statistics.put(PrometheusFormatField.THREADS_COUNT, this.threadCount);
        statistics.put(PrometheusFormatField.CPU_LOAD, this.cpuLoad);
        statistics.put(PrometheusFormatField.CLASS_COUNT, this.classCount);
        statistics.put(PrometheusFormatField.GC_COUNT, this.gcCount);
        statistics.put(PrometheusFormatField.DATA_DIR_USED, this.storageMemory.getDataDirUsed());
        statistics.put(PrometheusFormatField.WORK_DIR_USED, this.storageMemory.getWorkDirUsed());
        statistics.put(PrometheusFormatField.LOGS_DIR_USED, this.storageMemory.getLogsDirUsed());
        statistics.put(PrometheusFormatField.DATA_DIR_FREE, this.storageMemory.getDataDirFree());
        statistics.put(PrometheusFormatField.WORK_DIR_FREE, this.storageMemory.getWorkDirFree());
        statistics.put(PrometheusFormatField.LOGS_DIR_FREE, this.storageMemory.getLogsDirFree());
        if (this.openFileDescriptors != -1L && this.maxFileDescriptors != -1L) {
            statistics.put(PrometheusFormatField.OPEN_FILE_DESCRIPTORS, this.openFileDescriptors);
            statistics.put(PrometheusFormatField.MAX_FILE_DESCRIPTORS, this.maxFileDescriptors);
        }
        return PrometheusFormatField.parse(statistics);
    }

    private long calcMaxDirectMemory() {
        HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
        if (hotSpotDiagnosticMXBean != null) {
            return Long.parseLong(hotSpotDiagnosticMXBean.getVMOption("MaxDirectMemorySize").getValue());
        }
        return -1L;
    }
}

