/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.pp.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.exception.InvalidMappingSourceQueriesException;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.pp.PPMappingAssertionProvenance;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMappingConverter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression;
import it.unibz.inf.ontop.spec.sqlparser.SQLQueryParser;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLPPMappingConverterImpl
implements SQLPPMappingConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLPPMappingConverterImpl.class);
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final SQLQueryParser sqlQueryParser;
    private final boolean ignoreInvalidMappingEntries;

    @Inject
    private SQLPPMappingConverterImpl(CoreSingletons coreSingletons, SQLQueryParser sqlQueryParser) {
        this.iqFactory = coreSingletons.getIQFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.sqlQueryParser = sqlQueryParser;
        this.ignoreInvalidMappingEntries = ((OntopOBDASettings)coreSingletons.getSettings()).ignoreInvalidMappingEntries();
    }

    public ImmutableList<MappingAssertion> convert(ImmutableList<SQLPPTriplesMap> mapping, MetadataLookup metadataLookup) throws InvalidMappingSourceQueriesException, MetadataExtractionException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SQLPPTriplesMap assertion : mapping) {
            Function<Variable, Optional<ImmutableTerm>> lookup;
            IQTree tree;
            try {
                RAExpression re = this.getRAExpression(assertion, metadataLookup);
                tree = this.sqlQueryParser.convert(re);
                lookup = SQLPPMappingConverterImpl.placeholderLookup(assertion, metadataLookup.getQuotedIDFactory(), re.getUnqualifiedAttributes());
            }
            catch (InvalidMappingSourceQueriesException | MetadataExtractionException | RuntimeException e) {
                if (!this.ignoreInvalidMappingEntries) {
                    throw e;
                }
                LOGGER.warn("Mapping entry {} was ignored due to an issue: {}", (Object)assertion.getId(), (Object)e.getMessage());
                continue;
            }
            for (TargetAtom target : assertion.getTargetAtoms()) {
                try {
                    PPMappingAssertionProvenance provenance = assertion.getMappingAssertionProvenance(target);
                    builder.add((Object)this.convert(target, lookup, provenance, tree));
                }
                catch (InvalidMappingSourceQueriesException e) {
                    if (!this.ignoreInvalidMappingEntries) {
                        throw e;
                    }
                    LOGGER.warn("Target atom {} was ignored due to an issue: {}", (Object)target, (Object)e.getMessage());
                }
            }
        }
        ImmutableList result = builder.build();
        LOGGER.debug("Original mapping size: {}", (Object)result.size());
        return result;
    }

    private static <T> Function<Variable, Optional<T>> placeholderLookup(SQLPPTriplesMap mappingAssertion, QuotedIDFactory idFactory, ImmutableMap<QuotedID, T> lookup) {
        Function<Variable, Optional<T>> standard = v -> Optional.ofNullable(lookup.get((Object)idFactory.createAttributeID(v.getName())));
        if (mappingAssertion instanceof OntopNativeSQLPPTriplesMap) {
            RawQuotedIDFactory rawIdFactory = new RawQuotedIDFactory(idFactory);
            return arg_0 -> SQLPPMappingConverterImpl.lambda$placeholderLookup$2(standard, lookup, (QuotedIDFactory)rawIdFactory, arg_0);
        }
        return standard;
    }

    private MappingAssertion convert(TargetAtom target, Function<Variable, Optional<ImmutableTerm>> lookup, PPMappingAssertionProvenance provenance, IQTree tree) throws InvalidMappingSourceQueriesException {
        Substitution targetSubstitution = target.getSubstitution();
        ImmutableMap targetPreMap = (ImmutableMap)targetSubstitution.apply(target.getProjectionAtom().getArguments()).stream().flatMap(ImmutableTerm::getVariableStream).distinct().collect(ImmutableCollectors.toMap(v -> v, lookup));
        ImmutableList missingPlaceholders = (ImmutableList)targetPreMap.entrySet().stream().filter(e -> ((Optional)e.getValue()).isEmpty()).map(Map.Entry::getKey).map(Variable::getName).collect(ImmutableCollectors.toList());
        if (!missingPlaceholders.isEmpty()) {
            throw new InvalidMappingSourceQueriesException(missingPlaceholders.stream().collect(Collectors.joining(", ", "The placeholder(s) ", " in the target do(es) not occur in source query of the mapping assertion\n[" + provenance.getProvenanceInfo() + "]")));
        }
        Substitution substitution = (Substitution)targetPreMap.entrySet().stream().collect(this.substitutionFactory.toSubstitutionSkippingIdentityEntries(Map.Entry::getKey, e -> (ImmutableTerm)((Optional)e.getValue()).get()));
        Substitution targetRenamingPart = substitution.restrictRangeTo(Variable.class);
        Substitution spoSubstitution = targetSubstitution.transform(arg_0 -> ((Substitution)targetRenamingPart).applyToTerm(arg_0));
        Substitution selectSubstitution = substitution.restrictRangeTo(NonVariableTerm.class);
        UnaryIQTree selectTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(spoSubstitution.getRangeVariables(), selectSubstitution), tree);
        UnaryIQTree mappingTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(target.getProjectionAtom().getVariables(), spoSubstitution), (IQTree)selectTree);
        return new MappingAssertion(this.iqFactory.createIQ(target.getProjectionAtom(), (IQTree)mappingTree), provenance);
    }

    public RAExpression getRAExpression(SQLPPTriplesMap mappingAssertion, MetadataLookup metadataLookup) throws InvalidMappingSourceQueriesException, MetadataExtractionException {
        String sourceQuery = mappingAssertion.getSourceQuery().getSQL();
        try {
            return this.sqlQueryParser.getRAExpression(sourceQuery, metadataLookup);
        }
        catch (InvalidQueryException e) {
            throw new InvalidMappingSourceQueriesException("Error: " + e.getMessage() + " \nProblem location: source query of triplesMap \n[" + mappingAssertion.getTriplesMapProvenance().getProvenanceInfo() + "]");
        }
    }

    private static /* synthetic */ Optional lambda$placeholderLookup$2(Function standard, ImmutableMap lookup, QuotedIDFactory rawIdFactory, Variable v) {
        return Optional.ofNullable(((Optional)standard.apply(v)).orElseGet(() -> lookup.get((Object)rawIdFactory.createAttributeID(v.getName()))));
    }
}

