/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.pp.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.exception.MetaMappingExpansionException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTree2NativeNodeGenerator;
import it.unibz.inf.ontop.iq.type.NotYetTypedBinaryMathOperationTransformer;
import it.unibz.inf.ontop.iq.type.NotYetTypedEqualityTransformer;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.pp.impl.MetaMappingExpander;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.LocalJDBCConnectionUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Optional;

public class MetaMappingExpanderImpl
implements MetaMappingExpander {
    private final SubstitutionFactory substitutionFactory;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final NotYetTypedEqualityTransformer mappingEqualityTransformer;
    private final NotYetTypedBinaryMathOperationTransformer mappingBinaryMathOperationTransformer;
    private final IQTree2NativeNodeGenerator nativeNodeGenerator;
    private final OntopSQLCredentialSettings settings;

    @Inject
    private MetaMappingExpanderImpl(SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory, TermFactory termFactory, NotYetTypedEqualityTransformer mappingEqualityTransformer, NotYetTypedBinaryMathOperationTransformer mappingBinaryMathOperationTransformer, IQTree2NativeNodeGenerator nativeNodeGenerator, OntopSQLCredentialSettings settings) {
        this.substitutionFactory = substitutionFactory;
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        this.mappingEqualityTransformer = mappingEqualityTransformer;
        this.mappingBinaryMathOperationTransformer = mappingBinaryMathOperationTransformer;
        this.nativeNodeGenerator = nativeNodeGenerator;
        this.settings = settings;
    }

    @Override
    public ImmutableList<MappingAssertion> transform(ImmutableList<MappingAssertion> mapping, DBParameters dbParameters) throws MetaMappingExpansionException {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        ImmutableList.Builder positionsBuilder = ImmutableList.builder();
        for (MappingAssertion assertion : mapping) {
            Optional<ExpansionPosition> position = this.getExpansionPosition(assertion);
            if (!position.isPresent()) {
                resultBuilder.add((Object)assertion);
                continue;
            }
            positionsBuilder.add((Object)position.get());
        }
        ImmutableList positions = positionsBuilder.build();
        if (positions.isEmpty()) {
            return mapping;
        }
        try (Connection connection = LocalJDBCConnectionUtils.createConnection((OntopSQLCredentialSettings)this.settings);){
            for (ExpansionPosition position : positions) {
                NativeNode nativeNode = position.getDatabaseQuery(dbParameters);
                Statement st = connection.createStatement();
                try {
                    ResultSet rs = st.executeQuery(nativeNode.getNativeQueryString());
                    try {
                        while (rs.next()) {
                            Substitution sub = this.substitutionFactory.getSubstitutionThrowsExceptions((Collection)nativeNode.getVariables(), v -> v, v -> this.termFactory.getDBConstant(rs.getString(((QuotedID)nativeNode.getColumnNames().get(v)).getName()), (DBTermType)nativeNode.getTypeMap().get(v)));
                            resultBuilder.add((Object)position.createExpansion((Substitution<ImmutableTerm>)sub));
                        }
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                finally {
                    if (st == null) continue;
                    st.close();
                }
            }
        }
        catch (SQLException e) {
            throw new MetaMappingExpansionException((Exception)e);
        }
        return resultBuilder.build();
    }

    private Optional<ExpansionPosition> getExpansionPosition(MappingAssertion assertion) {
        RDFAtomPredicate predicate = assertion.getRDFAtomPredicate();
        RDFAtomPredicate.ComponentGetter componentGetter = assertion.getIndex().isClass() ? arg_0 -> ((RDFAtomPredicate)predicate).getObject(arg_0) : arg_0 -> ((RDFAtomPredicate)predicate).getProperty(arg_0);
        return componentGetter.get(assertion.getTerms()).isGround() ? Optional.empty() : Optional.of(new ExpansionPosition(assertion, (Variable)componentGetter.get(assertion.getProjectionAtom().getArguments())));
    }

    private final class ExpansionPosition {
        private final MappingAssertion assertion;
        private final Variable topVariable;

        ExpansionPosition(MappingAssertion assertion, Variable topVariable) {
            this.assertion = assertion;
            this.topVariable = topVariable;
        }

        NativeNode getDatabaseQuery(DBParameters dbParameters) {
            IQTree topChildNotNull = MetaMappingExpanderImpl.this.termFactory.getDBIsNotNull(this.assertion.getTopChild().getVariables().stream()).map(arg_0 -> ((IntermediateQueryFactory)MetaMappingExpanderImpl.this.iqFactory).createFilterNode(arg_0)).map(n -> MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, this.assertion.getTopChild())).orElse(this.assertion.getTopChild());
            UnaryIQTree constructionTree = MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MetaMappingExpanderImpl.this.iqFactory.createConstructionNode((ImmutableSet)this.assertion.getTopSubstitution().get(this.topVariable).getVariableStream().collect(ImmutableCollectors.toSet()), MetaMappingExpanderImpl.this.substitutionFactory.getSubstitution()), topChildNotNull);
            UnaryIQTree tree = MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MetaMappingExpanderImpl.this.iqFactory.createDistinctNode(), (IQTree)constructionTree);
            IQTree transformedTree = MetaMappingExpanderImpl.this.mappingEqualityTransformer.transform((IQTree)tree);
            IQTree binaryMathOperationTransformedTree = MetaMappingExpanderImpl.this.mappingBinaryMathOperationTransformer.transform(transformedTree);
            return MetaMappingExpanderImpl.this.nativeNodeGenerator.generate(binaryMathOperationTransformedTree, dbParameters, true);
        }

        MappingAssertion createExpansion(Substitution<ImmutableTerm> values) {
            Substitution instantiatedSub = this.assertion.getTopSubstitution().builder().transformOrRetain(arg_0 -> ((ImmutableMap)ImmutableMap.of((Object)this.topVariable, values)).get(arg_0), (t, sub) -> sub.applyToTerm(t)).build();
            UnaryIQTree filterTree = MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MetaMappingExpanderImpl.this.iqFactory.createFilterNode(MetaMappingExpanderImpl.this.termFactory.getConjunction((ImmutableList)values.builder().toStream((arg_0, arg_1) -> ((TermFactory)MetaMappingExpanderImpl.this.termFactory).getNotYetTypedEquality(arg_0, arg_1)).collect(ImmutableCollectors.toList()))), this.assertion.getTopChild());
            UnaryIQTree tree = MetaMappingExpanderImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)MetaMappingExpanderImpl.this.iqFactory.createConstructionNode(instantiatedSub.getDomain(), instantiatedSub), (IQTree)filterTree);
            return this.assertion.copyOf((IQTree)tree, MetaMappingExpanderImpl.this.iqFactory);
        }
    }
}

