/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;

public class SQLPPMappingFactoryImpl
implements SQLPPMappingFactory {
    private final OntopMappingSettings settings;

    @Inject
    private SQLPPMappingFactoryImpl(OntopMappingSettings settings) {
        this.settings = settings;
    }

    private Constructor<? extends SQLPPMapping> findConstructor(Class<SQLPPMapping> genericClass) {
        String implementationName = (String)this.settings.getProperty(genericClass.getCanonicalName()).orElseThrow(() -> new RuntimeException("No implementation declared for " + genericClass.getCanonicalName()));
        try {
            Class<SQLPPMapping> implementationClass = Class.forName(implementationName).asSubclass(genericClass);
            return implementationClass.getConstructor(ImmutableList.class, PrefixManager.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SQLPPMapping createSQLPreProcessedMapping(ImmutableList<SQLPPTriplesMap> ppMappingAxioms, PrefixManager prefixManager) {
        try {
            Constructor<? extends SQLPPMapping> constructor = this.findConstructor(SQLPPMapping.class);
            return constructor.newInstance(ppMappingAxioms, prefixManager);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new RuntimeException(targetException.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

