/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.VectorStoreChunkingStrategyRequest;
import com.azure.ai.openai.assistants.models.VectorStoreExpirationPolicy;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VectorStoreOptions
implements JsonSerializable<VectorStoreOptions> {
    private List<String> fileIds;
    private String name;
    private VectorStoreExpirationPolicy expiresAfter;
    private Map<String, String> metadata;
    private VectorStoreChunkingStrategyRequest chunkingStrategy;

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public VectorStoreOptions setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public VectorStoreOptions setName(String name) {
        this.name = name;
        return this;
    }

    public VectorStoreExpirationPolicy getExpiresAfter() {
        return this.expiresAfter;
    }

    public VectorStoreOptions setExpiresAfter(VectorStoreExpirationPolicy expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public VectorStoreOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("file_ids", this.fileIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("expires_after", (JsonSerializable)this.expiresAfter);
        jsonWriter.writeJsonField("chunking_strategy", (JsonSerializable)this.chunkingStrategy);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreOptions fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreOptions)jsonReader.readObject(reader -> {
            VectorStoreOptions deserializedVectorStoreOptions = new VectorStoreOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_ids".equals(fieldName)) {
                    List fileIds;
                    deserializedVectorStoreOptions.fileIds = fileIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVectorStoreOptions.name = reader.getString();
                    continue;
                }
                if ("expires_after".equals(fieldName)) {
                    deserializedVectorStoreOptions.expiresAfter = VectorStoreExpirationPolicy.fromJson(reader);
                    continue;
                }
                if ("chunking_strategy".equals(fieldName)) {
                    deserializedVectorStoreOptions.chunkingStrategy = VectorStoreChunkingStrategyRequest.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedVectorStoreOptions.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorStoreOptions;
        });
    }

    public VectorStoreChunkingStrategyRequest getChunkingStrategy() {
        return this.chunkingStrategy;
    }

    public VectorStoreOptions setChunkingStrategy(VectorStoreChunkingStrategyRequest chunkingStrategy) {
        this.chunkingStrategy = chunkingStrategy;
        return this;
    }
}

