/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.VectorStoreExpirationPolicy;
import com.azure.ai.openai.assistants.models.VectorStoreFileCount;
import com.azure.ai.openai.assistants.models.VectorStoreStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class VectorStore
implements JsonSerializable<VectorStore> {
    private final String id;
    private final String object = "vector_store";
    private final long createdAt;
    private final String name;
    private final int usageBytes;
    private final VectorStoreFileCount fileCounts;
    private final VectorStoreStatus status;
    private VectorStoreExpirationPolicy expiresAfter;
    private Long expiresAt;
    private final Long lastActiveAt;
    private final Map<String, String> metadata;

    private VectorStore(String id, OffsetDateTime createdAt, String name, int usageBytes, VectorStoreFileCount fileCounts, VectorStoreStatus status, OffsetDateTime lastActiveAt, Map<String, String> metadata) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.name = name;
        this.usageBytes = usageBytes;
        this.fileCounts = fileCounts;
        this.status = status;
        this.lastActiveAt = lastActiveAt == null ? null : Long.valueOf(lastActiveAt.toEpochSecond());
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public String getName() {
        return this.name;
    }

    public int getUsageBytes() {
        return this.usageBytes;
    }

    public VectorStoreFileCount getFileCounts() {
        return this.fileCounts;
    }

    public VectorStoreStatus getStatus() {
        return this.status;
    }

    public VectorStoreExpirationPolicy getExpiresAfter() {
        return this.expiresAfter;
    }

    public OffsetDateTime getExpiresAt() {
        if (this.expiresAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getLastActiveAt() {
        if (this.lastActiveAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.lastActiveAt), ZoneOffset.UTC);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeIntField("usage_bytes", this.usageBytes);
        jsonWriter.writeJsonField("file_counts", (JsonSerializable)this.fileCounts);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeNumberField("last_active_at", (Number)this.lastActiveAt);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("expires_after", (JsonSerializable)this.expiresAfter);
        jsonWriter.writeNumberField("expires_at", (Number)this.expiresAt);
        return jsonWriter.writeEndObject();
    }

    public static VectorStore fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStore)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String name = null;
            int usageBytes = 0;
            VectorStoreFileCount fileCounts = null;
            VectorStoreStatus status = null;
            OffsetDateTime lastActiveAt = null;
            Map metadata = null;
            VectorStoreExpirationPolicy expiresAfter = null;
            Long expiresAt = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("usage_bytes".equals(fieldName)) {
                    usageBytes = reader.getInt();
                    continue;
                }
                if ("file_counts".equals(fieldName)) {
                    fileCounts = VectorStoreFileCount.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = VectorStoreStatus.fromString(reader.getString());
                    continue;
                }
                if ("last_active_at".equals(fieldName)) {
                    Long lastActiveAtHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (lastActiveAtHolder == null) continue;
                    lastActiveAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(lastActiveAtHolder), ZoneOffset.UTC);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("expires_after".equals(fieldName)) {
                    expiresAfter = VectorStoreExpirationPolicy.fromJson(reader);
                    continue;
                }
                if ("expires_at".equals(fieldName)) {
                    expiresAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            VectorStore deserializedVectorStore = new VectorStore(id, createdAt, name, usageBytes, fileCounts, status, lastActiveAt, metadata);
            deserializedVectorStore.expiresAfter = expiresAfter;
            deserializedVectorStore.expiresAt = expiresAt;
            return deserializedVectorStore;
        });
    }
}

