/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.CodeInterpreterToolDefinition;
import com.azure.ai.openai.assistants.models.FileSearchToolDefinition;
import com.azure.ai.openai.assistants.models.FunctionToolDefinition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class ToolDefinition
implements JsonSerializable<ToolDefinition> {
    private String type = "ToolDefinition";

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ToolDefinition)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ToolDefinition toolDefinition;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("code_interpreter".equals(discriminatorValue)) {
                    toolDefinition = CodeInterpreterToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("file_search".equals(discriminatorValue)) {
                    toolDefinition = FileSearchToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                if ("function".equals(discriminatorValue)) {
                    toolDefinition = FunctionToolDefinition.fromJson(readerToUse.reset());
                    return toolDefinition;
                }
                toolDefinition = ToolDefinition.fromJsonKnownDiscriminator(readerToUse.reset());
                return toolDefinition;
            }
        });
    }

    static ToolDefinition fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ToolDefinition)jsonReader.readObject(reader -> {
            ToolDefinition deserializedToolDefinition = new ToolDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                reader.skipChildren();
            }
            return deserializedToolDefinition;
        });
    }

    public String getType() {
        return this.type;
    }
}

