/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.RunStepFunctionToolCallDetails;
import com.azure.ai.openai.assistants.models.RunStepToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RunStepFunctionToolCall
extends RunStepToolCall {
    private final RunStepFunctionToolCallDetails function;
    private String type = "function";

    private RunStepFunctionToolCall(String id, RunStepFunctionToolCallDetails function) {
        super(id);
        this.function = function;
    }

    public RunStepFunctionToolCallDetails getFunction() {
        return this.function;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeJsonField("function", (JsonSerializable)this.function);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RunStepFunctionToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepFunctionToolCall)jsonReader.readObject(reader -> {
            String id = null;
            RunStepFunctionToolCallDetails function = null;
            String type = "function";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("function".equals(fieldName)) {
                    function = RunStepFunctionToolCallDetails.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RunStepFunctionToolCall deserializedRunStepFunctionToolCall = new RunStepFunctionToolCall(id, function);
            deserializedRunStepFunctionToolCall.type = type;
            return deserializedRunStepFunctionToolCall;
        });
    }
}

