/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.FilePurpose;
import com.azure.ai.openai.assistants.models.FileState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class OpenAIFile
implements JsonSerializable<OpenAIFile> {
    private final String object = "file";
    private final String id;
    private final int bytes;
    private final String filename;
    private final long createdAt;
    private final FilePurpose purpose;
    private FileState status;
    private String statusDetails;

    private OpenAIFile(String id, int bytes, String filename, OffsetDateTime createdAt, FilePurpose purpose) {
        this.id = id;
        this.bytes = bytes;
        this.filename = filename;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.purpose = purpose;
    }

    public String getObject() {
        return this.object;
    }

    public String getId() {
        return this.id;
    }

    public int getBytes() {
        return this.bytes;
    }

    public String getFilename() {
        return this.filename;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public FilePurpose getPurpose() {
        return this.purpose;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeIntField("bytes", this.bytes);
        jsonWriter.writeStringField("filename", this.filename);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("purpose", this.purpose == null ? null : this.purpose.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("status_details", this.statusDetails);
        return jsonWriter.writeEndObject();
    }

    public static OpenAIFile fromJson(JsonReader jsonReader) throws IOException {
        return (OpenAIFile)jsonReader.readObject(reader -> {
            String id = null;
            int bytes = 0;
            String filename = null;
            OffsetDateTime createdAt = null;
            FilePurpose purpose = null;
            FileState status = null;
            String statusDetails = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("bytes".equals(fieldName)) {
                    bytes = reader.getInt();
                    continue;
                }
                if ("filename".equals(fieldName)) {
                    filename = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("purpose".equals(fieldName)) {
                    purpose = FilePurpose.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = FileState.fromString(reader.getString());
                    continue;
                }
                if ("status_details".equals(fieldName)) {
                    statusDetails = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            OpenAIFile deserializedOpenAIFile = new OpenAIFile(id, bytes, filename, createdAt, purpose);
            deserializedOpenAIFile.status = status;
            deserializedOpenAIFile.statusDetails = statusDetails;
            return deserializedOpenAIFile;
        });
    }

    public FileState getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }
}

