/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageContent;
import com.azure.ai.openai.assistants.models.MessageTextDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageTextContent
extends MessageContent {
    private final MessageTextDetails text;
    private String type = "text";

    public MessageTextContent(MessageTextDetails text) {
        this.text = text;
    }

    public MessageTextDetails getText() {
        return this.text;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("text", (JsonSerializable)this.text);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static MessageTextContent fromJson(JsonReader jsonReader) throws IOException {
        return (MessageTextContent)jsonReader.readObject(reader -> {
            MessageTextDetails text = null;
            String type = "text";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = MessageTextDetails.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            MessageTextContent deserializedMessageTextContent = new MessageTextContent(text);
            deserializedMessageTextContent.type = type;
            return deserializedMessageTextContent;
        });
    }
}

