/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageTextFileCitationAnnotation;
import com.azure.ai.openai.assistants.models.MessageTextFilePathAnnotation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class MessageTextAnnotation
implements JsonSerializable<MessageTextAnnotation> {
    private String type = "MessageTextAnnotation";
    private final String text;

    public MessageTextAnnotation(String text) {
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static MessageTextAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return (MessageTextAnnotation)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                MessageTextAnnotation messageTextAnnotation;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("file_citation".equals(discriminatorValue)) {
                    messageTextAnnotation = MessageTextFileCitationAnnotation.fromJson(readerToUse.reset());
                    return messageTextAnnotation;
                }
                if ("file_path".equals(discriminatorValue)) {
                    messageTextAnnotation = MessageTextFilePathAnnotation.fromJson(readerToUse.reset());
                    return messageTextAnnotation;
                }
                messageTextAnnotation = MessageTextAnnotation.fromJsonKnownDiscriminator(readerToUse.reset());
                return messageTextAnnotation;
            }
        });
    }

    static MessageTextAnnotation fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (MessageTextAnnotation)jsonReader.readObject(reader -> {
            String text = null;
            String type = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            MessageTextAnnotation deserializedMessageTextAnnotation = new MessageTextAnnotation(text);
            deserializedMessageTextAnnotation.type = type;
            return deserializedMessageTextAnnotation;
        });
    }
}

