/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.AssistantsApiResponseFormatOption;
import com.azure.ai.openai.assistants.models.AssistantsApiToolChoiceOption;
import com.azure.ai.openai.assistants.models.ThreadMessage;
import com.azure.ai.openai.assistants.models.ToolDefinition;
import com.azure.ai.openai.assistants.models.TruncationObject;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CreateRunOptions
implements JsonSerializable<CreateRunOptions> {
    private final String assistantId;
    private String model;
    private String instructions;
    private String additionalInstructions;
    private List<ToolDefinition> tools;
    private Map<String, String> metadata;
    private Boolean stream;
    private List<ThreadMessage> additionalMessages;
    private Double temperature;
    private Double topP;
    private Integer maxPromptTokens;
    private Integer maxCompletionTokens;
    private TruncationObject truncationStrategy;
    private BinaryData toolChoice;
    private BinaryData responseFormat;
    private Boolean parallelToolCalls;

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getModel() {
        return this.model;
    }

    public CreateRunOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public CreateRunOptions setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    public String getAdditionalInstructions() {
        return this.additionalInstructions;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public CreateRunOptions setTools(List<ToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CreateRunOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CreateRunOptions(String assistantId) {
        this.assistantId = assistantId;
    }

    public CreateRunOptions setAdditionalInstructions(String additionalInstructions) {
        this.additionalInstructions = additionalInstructions;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeStringField("additional_instructions", this.additionalInstructions);
        jsonWriter.writeArrayField("additional_messages", this.additionalMessages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeNumberField("max_prompt_tokens", (Number)this.maxPromptTokens);
        jsonWriter.writeNumberField("max_completion_tokens", (Number)this.maxCompletionTokens);
        jsonWriter.writeJsonField("truncation_strategy", (JsonSerializable)this.truncationStrategy);
        if (this.toolChoice != null) {
            jsonWriter.writeFieldName("tool_choice");
            this.toolChoice.writeTo(jsonWriter);
        }
        if (this.responseFormat != null) {
            jsonWriter.writeFieldName("response_format");
            this.responseFormat.writeTo(jsonWriter);
        }
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CreateRunOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CreateRunOptions)jsonReader.readObject(reader -> {
            String assistantId = null;
            String model = null;
            String instructions = null;
            String additionalInstructions = null;
            List additionalMessages = null;
            List tools = null;
            Boolean parallelToolCalls = null;
            Boolean stream = null;
            Double temperature = null;
            Double topP = null;
            Integer maxPromptTokens = null;
            Integer maxCompletionTokens = null;
            TruncationObject truncationStrategy = null;
            BinaryData toolChoice = null;
            BinaryData responseFormat = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                    continue;
                }
                if ("additional_instructions".equals(fieldName)) {
                    additionalInstructions = reader.getString();
                    continue;
                }
                if ("additional_messages".equals(fieldName)) {
                    additionalMessages = reader.readArray(reader1 -> ThreadMessage.fromJson(reader1));
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("max_prompt_tokens".equals(fieldName)) {
                    maxPromptTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("max_completion_tokens".equals(fieldName)) {
                    maxCompletionTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("truncation_strategy".equals(fieldName)) {
                    truncationStrategy = TruncationObject.fromJson(reader);
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            CreateRunOptions deserializedCreateRunOptions = new CreateRunOptions(assistantId);
            deserializedCreateRunOptions.model = model;
            deserializedCreateRunOptions.instructions = instructions;
            deserializedCreateRunOptions.additionalInstructions = additionalInstructions;
            deserializedCreateRunOptions.additionalMessages = additionalMessages;
            deserializedCreateRunOptions.tools = tools;
            deserializedCreateRunOptions.parallelToolCalls = parallelToolCalls;
            deserializedCreateRunOptions.stream = stream;
            deserializedCreateRunOptions.temperature = temperature;
            deserializedCreateRunOptions.topP = topP;
            deserializedCreateRunOptions.maxPromptTokens = maxPromptTokens;
            deserializedCreateRunOptions.maxCompletionTokens = maxCompletionTokens;
            deserializedCreateRunOptions.truncationStrategy = truncationStrategy;
            deserializedCreateRunOptions.toolChoice = toolChoice;
            deserializedCreateRunOptions.responseFormat = responseFormat;
            deserializedCreateRunOptions.metadata = metadata;
            return deserializedCreateRunOptions;
        });
    }

    Boolean isStream() {
        return this.stream;
    }

    CreateRunOptions setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public List<ThreadMessage> getAdditionalMessages() {
        return this.additionalMessages;
    }

    public CreateRunOptions setAdditionalMessages(List<ThreadMessage> additionalMessages) {
        this.additionalMessages = additionalMessages;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public CreateRunOptions setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public CreateRunOptions setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    public CreateRunOptions setMaxPromptTokens(Integer maxPromptTokens) {
        this.maxPromptTokens = maxPromptTokens;
        return this;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public CreateRunOptions setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
        return this;
    }

    public TruncationObject getTruncationStrategy() {
        return this.truncationStrategy;
    }

    public CreateRunOptions setTruncationStrategy(TruncationObject truncationStrategy) {
        this.truncationStrategy = truncationStrategy;
        return this;
    }

    public AssistantsApiToolChoiceOption getToolChoice() {
        return AssistantsApiToolChoiceOption.fromBinaryData(this.toolChoice);
    }

    public CreateRunOptions setToolChoice(AssistantsApiToolChoiceOption toolChoice) {
        this.toolChoice = toolChoice.getMode() != null ? BinaryData.fromObject((Object)((Object)toolChoice.getMode())) : (toolChoice.getToolChoice() != null ? BinaryData.fromObject((Object)toolChoice.getToolChoice()) : null);
        return this;
    }

    public AssistantsApiResponseFormatOption getResponseFormat() {
        return AssistantsApiResponseFormatOption.fromBinaryData(this.responseFormat);
    }

    public CreateRunOptions setResponseFormat(AssistantsApiResponseFormatOption responseFormat) {
        this.responseFormat = responseFormat.getFormat() != null ? BinaryData.fromObject((Object)responseFormat.getFormat()) : (responseFormat.getMode() != null ? BinaryData.fromObject((Object)((Object)responseFormat.getMode())) : null);
        return this;
    }

    public Boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public CreateRunOptions setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
        return this;
    }
}

