/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.implementation.models;

import com.azure.ai.openai.assistants.models.Assistant;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class OpenAIPageableListOfAssistant
implements JsonSerializable<OpenAIPageableListOfAssistant> {
    private final String object = "list";
    private final List<Assistant> data;
    private final String firstId;
    private final String lastId;
    private final boolean hasMore;

    private OpenAIPageableListOfAssistant(List<Assistant> data, String firstId, String lastId, boolean hasMore) {
        this.data = data;
        this.firstId = firstId;
        this.lastId = lastId;
        this.hasMore = hasMore;
    }

    public String getObject() {
        return this.object;
    }

    public List<Assistant> getData() {
        return this.data;
    }

    public String getFirstId() {
        return this.firstId;
    }

    public String getLastId() {
        return this.lastId;
    }

    public boolean isHasMore() {
        return this.hasMore;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("first_id", this.firstId);
        jsonWriter.writeStringField("last_id", this.lastId);
        jsonWriter.writeBooleanField("has_more", this.hasMore);
        return jsonWriter.writeEndObject();
    }

    public static OpenAIPageableListOfAssistant fromJson(JsonReader jsonReader) throws IOException {
        return (OpenAIPageableListOfAssistant)jsonReader.readObject(reader -> {
            List data = null;
            String firstId = null;
            String lastId = null;
            boolean hasMore = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    data = reader.readArray(reader1 -> Assistant.fromJson(reader1));
                    continue;
                }
                if ("first_id".equals(fieldName)) {
                    firstId = reader.getString();
                    continue;
                }
                if ("last_id".equals(fieldName)) {
                    lastId = reader.getString();
                    continue;
                }
                if ("has_more".equals(fieldName)) {
                    hasMore = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return new OpenAIPageableListOfAssistant(data, firstId, lastId, hasMore);
        });
    }
}

