/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.implementation.models;

import com.azure.ai.openai.assistants.models.VectorStoreChunkingStrategyRequest;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CreateVectorStoreFileBatchRequest
implements JsonSerializable<CreateVectorStoreFileBatchRequest> {
    private final List<String> fileIds;
    private VectorStoreChunkingStrategyRequest chunkingStrategy;

    public CreateVectorStoreFileBatchRequest(List<String> fileIds) {
        this.fileIds = fileIds;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("file_ids", this.fileIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("chunking_strategy", (JsonSerializable)this.chunkingStrategy);
        return jsonWriter.writeEndObject();
    }

    public static CreateVectorStoreFileBatchRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateVectorStoreFileBatchRequest)jsonReader.readObject(reader -> {
            List fileIds = null;
            VectorStoreChunkingStrategyRequest chunkingStrategy = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_ids".equals(fieldName)) {
                    fileIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("chunking_strategy".equals(fieldName)) {
                    chunkingStrategy = VectorStoreChunkingStrategyRequest.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            CreateVectorStoreFileBatchRequest deserializedCreateVectorStoreFileBatchRequest = new CreateVectorStoreFileBatchRequest(fileIds);
            deserializedCreateVectorStoreFileBatchRequest.chunkingStrategy = chunkingStrategy;
            return deserializedCreateVectorStoreFileBatchRequest;
        });
    }

    public VectorStoreChunkingStrategyRequest getChunkingStrategy() {
        return this.chunkingStrategy;
    }

    public CreateVectorStoreFileBatchRequest setChunkingStrategy(VectorStoreChunkingStrategyRequest chunkingStrategy) {
        this.chunkingStrategy = chunkingStrategy;
        return this;
    }
}

