/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.implementation.models;

import com.azure.ai.openai.assistants.models.MessageRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CreateMessageRequest
implements JsonSerializable<CreateMessageRequest> {
    private final MessageRole role;
    private final String content;
    private List<String> fileIds;
    private Map<String, String> metadata;

    public CreateMessageRequest(MessageRole role, String content) {
        this.role = role;
        this.content = content;
    }

    public MessageRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public CreateMessageRequest setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CreateMessageRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("file_ids", this.fileIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CreateMessageRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateMessageRequest)jsonReader.readObject(reader -> {
            MessageRole role = null;
            String content = null;
            List fileIds = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    role = MessageRole.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("file_ids".equals(fieldName)) {
                    fileIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            CreateMessageRequest deserializedCreateMessageRequest = new CreateMessageRequest(role, content);
            deserializedCreateMessageRequest.fileIds = fileIds;
            deserializedCreateMessageRequest.metadata = metadata;
            return deserializedCreateMessageRequest;
        });
    }
}

