/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugins.textmining.iterators;

import com.ontotext.graphdb.plugins.textmining.clients.TextMiningClient;
import com.ontotext.graphdb.plugins.textmining.iterators.AbstractResultIterator;
import com.ontotext.graphdb.plugins.textmining.plugin.TextMiningRequestContext;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class MasterResultIterator
extends AbstractResultIterator {
    private Set<String> annotateText = new HashSet<String>();
    private Map<String, String> documentFeatures = new HashMap<String, String>();
    private final TextMiningRequestContext textMiningRequestContext;
    private boolean done = false;
    private TextMiningClient textMiningClient;
    private final BNode docNode;

    public MasterResultIterator(Entities entities, TextMiningRequestContext textMiningRequestContext) {
        this.setEntities(entities);
        this.docNode = SimpleValueFactory.getInstance().createBNode();
        this.subject = entities.put((Value)this.docNode, Entities.Scope.REQUEST);
        this.textMiningRequestContext = textMiningRequestContext;
    }

    public Resource getDocNode() {
        return this.docNode;
    }

    public TextMiningRequestContext getTextMiningRequestContext() {
        return this.textMiningRequestContext;
    }

    public boolean next() {
        if (this.closed) {
            return false;
        }
        if (this.done) {
            this.textMiningRequestContext.unregisterIterator(this);
            return false;
        }
        this.done = true;
        return true;
    }

    public String getAnnotateText() {
        return this.annotateText.stream().findFirst().orElse(null);
    }

    public void setAnnotateText(Value textValue) {
        if (textValue == null) {
            throw new ClientErrorException("No value to annotate. Is the variable bound?");
        }
        if (!(textValue instanceof Literal)) {
            throw new ClientErrorException("The content for annotated document should be literal.");
        }
        if (!this.annotateText.isEmpty() & this.annotateText.add(textValue.stringValue())) {
            throw new ClientErrorException("Only one value of text or rawInput should be provided");
        }
    }

    public TextMiningClient getTextMiningClient() {
        return this.textMiningClient;
    }

    public void setTextMiningClient(TextMiningClient textMiningClient) {
        this.textMiningClient = textMiningClient;
    }

    public Map<String, String> getDocumentFeatures() {
        return this.documentFeatures;
    }

    public void setDocumentFeatures(Map<String, String> documentFeatures) {
        this.documentFeatures = documentFeatures;
    }
}

