/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.constraints.impl.ExtensionalDataNodeListContainmentCheck;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.mapping.MappingAssertion;
import it.unibz.inf.ontop.spec.mapping.MappingAssertionIndex;
import it.unibz.inf.ontop.spec.mapping.TMappingExclusionConfig;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCQCOptimizer;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingSaturator;
import it.unibz.inf.ontop.spec.mapping.transformer.impl.MappingAssertionUnion;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.DataSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.EquivalencesDAG;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

@Singleton
public class TMappingSaturatorImpl
implements MappingSaturator {
    private final TMappingExclusionConfig tMappingExclusionConfig;
    private final TermFactory termFactory;
    private final MappingCQCOptimizer mappingCqcOptimizer;
    private final UnionBasedQueryMerger queryMerger;
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    private TMappingSaturatorImpl(TMappingExclusionConfig tMappingExclusionConfig, MappingCQCOptimizer mappingCqcOptimizer, UnionBasedQueryMerger queryMerger, CoreSingletons coreSingletons) {
        this.tMappingExclusionConfig = tMappingExclusionConfig;
        this.termFactory = coreSingletons.getTermFactory();
        this.mappingCqcOptimizer = mappingCqcOptimizer;
        this.queryMerger = queryMerger;
        this.coreSingletons = coreSingletons;
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public ImmutableList<MappingAssertion> saturate(ImmutableList<MappingAssertion> mapping, ClassifiedTBox reasoner) {
        ExtensionalDataNodeListContainmentCheck cqc = new ExtensionalDataNodeListContainmentCheck(this.coreSingletons.getHomomorphismFactory(), this.coreSingletons.getCoreUtilsFactory());
        ImmutableMultimap original = (ImmutableMultimap)mapping.stream().map(m -> this.optimize(cqc, (MappingAssertion)m)).collect(ImmutableCollectors.toMultimap(MappingAssertion::getIndex, m -> m));
        ImmutableMap saturated = (ImmutableMap)original.keySet().stream().map(MappingAssertionIndex::getPredicate).distinct().map(x$0 -> new MappingAssertionConstructionNodeTransformerProvider((RDFAtomPredicate)x$0)).flatMap(provider -> Stream.concat(Stream.concat(reasoner.objectPropertiesDAG().stream().filter(node -> !((ObjectPropertyExpression)node.getRepresentative()).isInverse() && !this.tMappingExclusionConfig.contains((ObjectPropertyExpression)node.getRepresentative())).flatMap(node -> this.saturate((ObjectPropertyExpression)node.getRepresentative(), TMappingSaturatorImpl.getSubsumees(reasoner.objectPropertiesDAG(), node), (ImmutableMultimap<MappingAssertionIndex, MappingAssertion>)original, provider::getTransformer, cqc).stream().flatMap(ma -> node.getMembers().stream().filter(d -> !d.isInverse() || d.getInverse() != node.getRepresentative()).map(d -> Maps.immutableEntry((Object)provider.getTransformer((ObjectPropertyExpression)node.getRepresentative(), (ObjectPropertyExpression)d), (Object)ma)))), reasoner.dataPropertiesDAG().stream().filter(node -> !this.tMappingExclusionConfig.contains((DataPropertyExpression)node.getRepresentative())).flatMap(node -> this.saturate((DataPropertyExpression)node.getRepresentative(), TMappingSaturatorImpl.getSubsumees(reasoner.dataPropertiesDAG(), node), (ImmutableMultimap<MappingAssertionIndex, MappingAssertion>)original, provider::getTransformer, cqc).stream().flatMap(ma -> node.getMembers().stream().map(d -> Maps.immutableEntry((Object)provider.getTransformer((DataPropertyExpression)node.getRepresentative(), (DataPropertyExpression)d), (Object)ma))))), reasoner.classesDAG().stream().filter(node -> node.getRepresentative() instanceof OClass && !this.tMappingExclusionConfig.contains((OClass)node.getRepresentative())).flatMap(node -> this.saturate((ClassExpression)node.getRepresentative(), TMappingSaturatorImpl.getSubsumees(reasoner.classesDAG(), node), (ImmutableMultimap<MappingAssertionIndex, MappingAssertion>)original, provider::getTransformer, cqc).stream().flatMap(ma -> node.getMembers().stream().filter(d -> d instanceof OClass).map(d -> Maps.immutableEntry((Object)provider.getTransformer((ClassExpression)node.getRepresentative(), (ClassExpression)d), (Object)ma)))))).map(e -> Maps.immutableEntry((Object)((MappingAssertionConstructionNodeTransformer)e.getKey()).getToIndex(), (Object)((MappingAssertionConstructionNodeTransformer)e.getKey()).updateConstructionNodeIri((MappingAssertion)e.getValue()))).collect(ImmutableCollectors.toMap());
        return (ImmutableList)Stream.concat(saturated.values().stream(), original.asMap().entrySet().stream().filter(e -> !saturated.containsKey(e.getKey())).map(e -> ((Collection)e.getValue()).stream().collect(MappingAssertionUnion.toMappingAssertion(cqc, this.coreSingletons, this.queryMerger))).map(Optional::get)).collect(ImmutableCollectors.toList());
    }

    private MappingAssertion optimize(ExtensionalDataNodeListContainmentCheck cqc, MappingAssertion m) {
        IQ optimizedIQ = m.getQuery().normalizeForOptimization();
        IQ cqcOptimizedIQ = this.mappingCqcOptimizer.optimize(cqc, optimizedIQ);
        return m.copyOf(cqcOptimizedIQ);
    }

    private <T> Optional<MappingAssertion> saturate(T representative, Stream<T> subsumees, ImmutableMultimap<MappingAssertionIndex, MappingAssertion> original, BiFunction<T, T, MappingAssertionConstructionNodeTransformer> transformerProvider, ExtensionalDataNodeListContainmentCheck cqc) {
        return subsumees.map(s -> (MappingAssertionConstructionNodeTransformer)transformerProvider.apply(s, representative)).flatMap(u -> original.get((Object)u.getFromIndex()).stream().map(u::updateConstructionNodeIri).map(m -> u.needOptimization() ? this.optimize(cqc, (MappingAssertion)m) : m)).collect(MappingAssertionUnion.toMappingAssertion(cqc, this.coreSingletons, this.queryMerger));
    }

    private static <T> Stream<T> getSubsumees(EquivalencesDAG<T> dag, Equivalences<T> node) {
        return dag.getSub(node).stream().flatMap(n -> n.getMembers().stream());
    }

    private class MappingAssertionConstructionNodeTransformerProvider {
        private final RDFAtomPredicate rdfAtomPredicate;
        private final IRIConstant rdfType;

        MappingAssertionConstructionNodeTransformerProvider(RDFAtomPredicate rdfAtomPredicate) {
            this.rdfAtomPredicate = rdfAtomPredicate;
            this.rdfType = TMappingSaturatorImpl.this.termFactory.getConstantIRI(RDF.TYPE);
        }

        MappingAssertionConstructionNodeTransformer getTransformer(ClassExpression from, ClassExpression to) {
            if (!(to instanceof OClass)) {
                throw new MinorOntopInternalBugException("Cannot get a transformer to a property restriction: " + from + " " + to);
            }
            OClass toClass = (OClass)to;
            IRIConstant newIri = TMappingSaturatorImpl.this.termFactory.getConstantIRI(toClass.getIRI());
            if (from instanceof OClass) {
                OClass oc = (OClass)from;
                return new MappingAssertionConstructionNodeTransformer(MappingAssertionIndex.ofClass(this.rdfAtomPredicate, oc.getIRI()), MappingAssertionIndex.ofClass(this.rdfAtomPredicate, toClass.getIRI()), args -> this.rdfAtomPredicate.updateSPO(args, this.rdfAtomPredicate.getSubject(args), (ImmutableTerm)this.rdfType, (ImmutableTerm)newIri), false);
            }
            if (from instanceof ObjectSomeValuesFrom) {
                ObjectPropertyExpression ope = ((ObjectSomeValuesFrom)from).getProperty();
                return new MappingAssertionConstructionNodeTransformer(MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, ope.getIRI()), MappingAssertionIndex.ofClass(this.rdfAtomPredicate, toClass.getIRI()), ope.isInverse() ? args -> this.rdfAtomPredicate.updateSPO(args, this.rdfAtomPredicate.getObject(args), (ImmutableTerm)this.rdfType, (ImmutableTerm)newIri) : args -> this.rdfAtomPredicate.updateSPO(args, this.rdfAtomPredicate.getSubject(args), (ImmutableTerm)this.rdfType, (ImmutableTerm)newIri), true);
            }
            if (from instanceof DataSomeValuesFrom) {
                DataPropertyExpression dpe = ((DataSomeValuesFrom)from).getProperty();
                return new MappingAssertionConstructionNodeTransformer(MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, dpe.getIRI()), MappingAssertionIndex.ofClass(this.rdfAtomPredicate, toClass.getIRI()), args -> this.rdfAtomPredicate.updateSPO(args, this.rdfAtomPredicate.getSubject(args), (ImmutableTerm)this.rdfType, (ImmutableTerm)newIri), true);
            }
            throw new MinorOntopInternalBugException("Unexpected type" + from);
        }

        MappingAssertionConstructionNodeTransformer getTransformer(ObjectPropertyExpression from, ObjectPropertyExpression to) {
            IRIConstant newIri = TMappingSaturatorImpl.this.termFactory.getConstantIRI(to.getIRI());
            return new MappingAssertionConstructionNodeTransformer(MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, from.getIRI()), MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, to.getIRI()), from.isInverse() != to.isInverse() ? args -> this.rdfAtomPredicate.updateSPO(args, this.rdfAtomPredicate.getObject(args), (ImmutableTerm)newIri, this.rdfAtomPredicate.getSubject(args)) : args -> this.rdfAtomPredicate.updateSPO(args, this.rdfAtomPredicate.getSubject(args), (ImmutableTerm)newIri, this.rdfAtomPredicate.getObject(args)), false);
        }

        MappingAssertionConstructionNodeTransformer getTransformer(DataPropertyExpression from, DataPropertyExpression to) {
            IRIConstant newIri = TMappingSaturatorImpl.this.termFactory.getConstantIRI(to.getIRI());
            return new MappingAssertionConstructionNodeTransformer(MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, from.getIRI()), MappingAssertionIndex.ofProperty(this.rdfAtomPredicate, to.getIRI()), args -> this.rdfAtomPredicate.updateSPO(args, this.rdfAtomPredicate.getSubject(args), (ImmutableTerm)newIri, this.rdfAtomPredicate.getObject(args)), false);
        }
    }

    private class MappingAssertionConstructionNodeTransformer {
        private final MappingAssertionIndex fromIndex;
        private final MappingAssertionIndex toIndex;
        private final Function<ImmutableList<ImmutableTerm>, ImmutableList<ImmutableTerm>> termTransformer;
        private final boolean needOptimization;

        MappingAssertionConstructionNodeTransformer(MappingAssertionIndex fromIndex, MappingAssertionIndex toIndex, Function<ImmutableList<ImmutableTerm>, ImmutableList<ImmutableTerm>> termTransformer, boolean needOptimization) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.termTransformer = termTransformer;
            this.needOptimization = needOptimization;
        }

        MappingAssertionIndex getFromIndex() {
            return this.fromIndex;
        }

        MappingAssertionIndex getToIndex() {
            return this.toIndex;
        }

        boolean needOptimization() {
            return this.needOptimization;
        }

        MappingAssertion updateConstructionNodeIri(MappingAssertion assertion) {
            IQ query = assertion.getQuery();
            ConstructionNode constructionNode = (ConstructionNode)query.getTree().getRootNode();
            DistinctVariableOnlyDataAtom projectionAtom = query.getProjectionAtom();
            ImmutableList variables = projectionAtom.getArguments();
            ImmutableList args = constructionNode.getSubstitution().apply(variables);
            Substitution updatedSubstitution = TMappingSaturatorImpl.this.substitutionFactory.getSubstitution(variables, this.termTransformer.apply((ImmutableList<ImmutableTerm>)args));
            ConstructionNode updatedConstructionNode = TMappingSaturatorImpl.this.iqFactory.createConstructionNode(constructionNode.getVariables(), updatedSubstitution);
            IQ updatedQuery = TMappingSaturatorImpl.this.iqFactory.createIQ(projectionAtom, (IQTree)TMappingSaturatorImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)updatedConstructionNode, ((UnaryIQTree)query.getTree()).getChild()));
            return assertion.copyOf(updatedQuery);
        }

        public String toString() {
            return this.fromIndex + " -> " + this.toIndex;
        }
    }
}

