/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.constraints.impl.ExtensionalDataNodeListContainmentCheck;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.LazyRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.spec.mapping.transformer.MappingCQCOptimizer;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingCQCOptimizerImpl
implements MappingCQCOptimizer {
    private static final Logger log = LoggerFactory.getLogger(MappingCQCOptimizerImpl.class);
    private final IntermediateQueryFactory iqFactory;

    @Inject
    public MappingCQCOptimizerImpl(CoreSingletons coreSingletons) {
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public IQ optimize(final ExtensionalDataNodeListContainmentCheck cqContainmentCheck, IQ query) {
        IQTree tree = query.getTree();
        final ConstructionNode constructionNode = (ConstructionNode)tree.getRootNode();
        return this.iqFactory.createIQ(query.getProjectionAtom(), tree.acceptTransformer((IQTreeVisitingTransformer)new LazyRecursiveIQTreeVisitingTransformer(this.iqFactory){

            public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children0) {
                Optional joiningConditions = rootNode.getOptionalFilterCondition();
                ImmutableList extensionalDataNodes = (ImmutableList)tree.getChildren().stream().filter(n -> n instanceof ExtensionalDataNode).map(n -> (ExtensionalDataNode)n).collect(ImmutableCollectors.toList());
                ImmutableList answerVariables = (ImmutableList)Stream.concat(constructionNode.getSubstitution().getRangeVariables().stream(), joiningConditions.stream().flatMap(ImmutableTerm::getVariableStream)).distinct().collect(ImmutableCollectors.toList());
                int currentIndex = 0;
                while (currentIndex < extensionalDataNodes.size()) {
                    ExtensionalDataNode current = (ExtensionalDataNode)extensionalDataNodes.get(currentIndex);
                    ImmutableList extensionalDataNodesExceptCurrent = (ImmutableList)extensionalDataNodes.stream().filter(child -> child != current).collect(ImmutableCollectors.toList());
                    if (((ImmutableSet)extensionalDataNodesExceptCurrent.stream().flatMap(a -> a.getVariables().stream()).collect(ImmutableCollectors.toSet())).containsAll((Collection)answerVariables)) {
                        if (cqContainmentCheck.isContainedIn(answerVariables, extensionalDataNodesExceptCurrent, answerVariables, extensionalDataNodes)) {
                            log.debug("CQC-REMOVED: " + extensionalDataNodes.get(currentIndex) + " FROM " + extensionalDataNodes);
                            extensionalDataNodes = extensionalDataNodesExceptCurrent;
                            if (extensionalDataNodes.size() < 2) break;
                            currentIndex = 0;
                            continue;
                        }
                        ++currentIndex;
                        continue;
                    }
                    ++currentIndex;
                }
                ImmutableList children = (ImmutableList)Stream.concat(extensionalDataNodes.stream(), tree.getChildren().stream().filter(n -> !(n instanceof ExtensionalDataNode))).collect(ImmutableCollectors.toList());
                switch (children.size()) {
                    case 0: {
                        return this.iqFactory.createTrueNode();
                    }
                    case 1: {
                        return joiningConditions.map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(c), (IQTree)children.get(0))).orElseGet(() -> (IQTree)children.get(0));
                    }
                }
                return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(joiningConditions), children);
            }
        }));
    }
}

