/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.transformer.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class DisjunctionOfConjunctions {
    private final ImmutableSet<ImmutableSet<ImmutableExpression>> conjunctions;

    private DisjunctionOfConjunctions(ImmutableSet<ImmutableSet<ImmutableExpression>> conjunctions) {
        this.conjunctions = conjunctions;
    }

    public static DisjunctionOfConjunctions getOR(DisjunctionOfConjunctions o1, DisjunctionOfConjunctions o2) {
        if (o1.isTrue()) {
            return o1;
        }
        if (o2.isTrue()) {
            return o2;
        }
        Builder builder = new Builder(o1);
        o2.conjunctions.forEach(builder::add);
        return builder.build();
    }

    public static DisjunctionOfConjunctions getAND(DisjunctionOfConjunctions o1, DisjunctionOfConjunctions o2) {
        if (o1.isTrue()) {
            return o2;
        }
        if (o2.isTrue()) {
            return o1;
        }
        return new DisjunctionOfConjunctions((ImmutableSet<ImmutableSet<ImmutableExpression>>)((ImmutableSet)o1.conjunctions.stream().flatMap(s1 -> o2.conjunctions.stream().map(s2 -> Sets.union((Set)s1, (Set)s2).immutableCopy())).collect(ImmutableCollectors.toSet())));
    }

    public static DisjunctionOfConjunctions getTrue() {
        return new DisjunctionOfConjunctions((ImmutableSet<ImmutableSet<ImmutableExpression>>)ImmutableSet.of());
    }

    public boolean isTrue() {
        return this.conjunctions.isEmpty();
    }

    public int getNumberOfConjunctions() {
        return this.conjunctions.size();
    }

    public static DisjunctionOfConjunctions of(ImmutableExpression e) {
        return e.flattenOR().map(c -> (ImmutableSet)c.flattenAND().collect(ImmutableCollectors.toSet())).collect(DisjunctionOfConjunctions.toDisjunctionOfConjunctions());
    }

    public ImmutableSet<Variable> getVariables() {
        return (ImmutableSet)this.conjunctions.stream().flatMap(d -> d.stream().flatMap(ImmutableTerm::getVariableStream)).collect(ImmutableCollectors.toSet());
    }

    public Stream<ImmutableSet<ImmutableExpression>> stream() {
        return this.conjunctions.stream();
    }

    public boolean equals(Object o) {
        if (o instanceof DisjunctionOfConjunctions) {
            DisjunctionOfConjunctions other = (DisjunctionOfConjunctions)o;
            return this.conjunctions.equals(other.conjunctions);
        }
        return false;
    }

    public int hashCode() {
        return this.conjunctions.hashCode();
    }

    public String toString() {
        return this.conjunctions.toString();
    }

    public static Collector<ImmutableSet<ImmutableExpression>, Builder, DisjunctionOfConjunctions> toDisjunctionOfConjunctions() {
        return Collector.of(Builder::new, Builder::add, Builder::addAll, Builder::build, Collector.Characteristics.UNORDERED);
    }

    private static class Builder {
        final Set<ImmutableSet<ImmutableExpression>> disjunctions;

        Builder() {
            this.disjunctions = new HashSet<ImmutableSet<ImmutableExpression>>();
        }

        Builder(DisjunctionOfConjunctions disjunctionOfConjunctions) {
            this.disjunctions = new HashSet<ImmutableSet<ImmutableExpression>>((Collection<ImmutableSet<ImmutableExpression>>)disjunctionOfConjunctions.conjunctions);
        }

        void add(ImmutableSet<ImmutableExpression> conjunction) {
            if (this.disjunctions.stream().noneMatch(arg_0 -> conjunction.containsAll(arg_0))) {
                this.disjunctions.removeIf(c -> c.containsAll((Collection)conjunction));
                this.disjunctions.add(conjunction);
            }
        }

        Builder addAll(Builder other) {
            Builder builder = new Builder();
            builder.disjunctions.addAll(this.disjunctions);
            other.disjunctions.forEach(builder::add);
            return builder;
        }

        DisjunctionOfConjunctions build() {
            return new DisjunctionOfConjunctions((ImmutableSet<ImmutableSet<ImmutableExpression>>)ImmutableSet.copyOf(this.disjunctions));
        }
    }
}

