/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.parser.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.template.impl.BnodeTemplateFactory;
import it.unibz.inf.ontop.model.template.impl.IRITemplateFactory;
import it.unibz.inf.ontop.model.template.impl.LiteralTemplateFactory;
import it.unibz.inf.ontop.model.template.impl.ObjectTemplateFactory;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDABaseVisitor;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDAParser;
import it.unibz.inf.ontop.spec.mapping.parser.impl.TurtleOBDAVisitor;
import java.util.Optional;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class TurtleOBDASQLTermVisitor
extends TurtleOBDABaseVisitor<ImmutableTerm>
implements TurtleOBDAVisitor<ImmutableTerm> {
    private final PrefixManager prefixManager;
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;
    private final OntopMappingSettings settings;
    private final IRITemplateFactory iriTemplateFactory;
    private final BnodeTemplateFactory bnodeTemplateFactory;
    private final LiteralTemplateFactory literalTemplateFactory;

    TurtleOBDASQLTermVisitor(TermFactory termFactory, TypeFactory typeFactory, OntopMappingSettings settings, PrefixManager prefixManager) {
        this.termFactory = termFactory;
        this.typeFactory = typeFactory;
        this.settings = settings;
        this.prefixManager = prefixManager;
        this.iriTemplateFactory = new IRITemplateFactory(termFactory);
        this.bnodeTemplateFactory = new BnodeTemplateFactory(termFactory);
        this.literalTemplateFactory = new LiteralTemplateFactory(termFactory, typeFactory);
    }

    @Override
    public ImmutableTerm visitPredicateRdfType(TurtleOBDAParser.PredicateRdfTypeContext ctx) {
        return this.termFactory.getConstantIRI(RDF.TYPE);
    }

    @Override
    public ImmutableTerm visitResourceIri(TurtleOBDAParser.ResourceIriContext ctx) {
        String text = ctx.IRIREF().getText();
        return TurtleOBDASQLTermVisitor.getTermForObjectTemplate(text.substring(1, text.length() - 1), (ObjectTemplateFactory)this.iriTemplateFactory);
    }

    @Override
    public ImmutableTerm visitResourcePrefixedIri(TurtleOBDAParser.ResourcePrefixedIriContext ctx) {
        return TurtleOBDASQLTermVisitor.getTermForObjectTemplate(this.prefixManager.getExpandForm(ctx.PNAME_LN().getText()), (ObjectTemplateFactory)this.iriTemplateFactory);
    }

    @Override
    public ImmutableTerm visitBlankNode(TurtleOBDAParser.BlankNodeContext ctx) {
        return TurtleOBDASQLTermVisitor.getTermForObjectTemplate(ctx.BLANK_NODE_LABEL().getText().substring(2), (ObjectTemplateFactory)this.bnodeTemplateFactory);
    }

    private static ImmutableTerm getTermForObjectTemplate(String template, ObjectTemplateFactory factory) {
        ImmutableList components = factory.getComponents(template);
        if (components.size() == 1 && ((Template.Component)components.get(0)).isColumn()) {
            return factory.getColumn(((Template.Component)components.get(0)).getComponent());
        }
        return factory.getTemplateTerm(components);
    }

    @Override
    public ImmutableTerm visitBlankNodeAnonymous(TurtleOBDAParser.BlankNodeAnonymousContext ctx) {
        throw new IllegalArgumentException("Anonymous blank nodes not supported yet in mapping targets");
    }

    @Override
    public ImmutableTerm visitConstantRdfLiteral(TurtleOBDAParser.ConstantRdfLiteralContext ctx) {
        Optional<RDFDatatype> rdfDatatype = this.extractDatatype(ctx.LANGTAG(), ctx.iri());
        String text = ctx.STRING_LITERAL_QUOTE().getText();
        String template = TurtleUtil.decodeString((String)text.substring(1, text.length() - 1));
        ImmutableList components = this.literalTemplateFactory.getComponents(template);
        NonVariableTerm lexicalValue = this.literalTemplateFactory.getTemplateTerm(components);
        return this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)lexicalValue, rdfDatatype.orElse(this.typeFactory.getXsdStringDatatype()));
    }

    @Override
    public ImmutableTerm visitVariableRdfLiteral(TurtleOBDAParser.VariableRdfLiteralContext ctx) {
        Optional<RDFDatatype> rdfDatatype = this.extractDatatype(ctx.LANGTAG(), ctx.iri());
        rdfDatatype.filter(dt -> !this.settings.areAbstractDatatypesToleratedInMapping()).filter(TermType::isAbstract).ifPresent(dt -> {
            throw new IllegalArgumentException("The datatype of a literal must not be abstract: " + dt.getIRI() + "\nSet the property ontop.tolerateAbstractDatatype to true to tolerate them.");
        });
        String text = ctx.ENCLOSED_COLUMN_NAME().getText();
        String column = text.substring(1, text.length() - 1);
        return this.termFactory.getRDFLiteralFunctionalTerm((ImmutableTerm)this.literalTemplateFactory.getColumn(column), rdfDatatype.orElse(this.typeFactory.getAbstractRDFSLiteral()));
    }

    private Optional<RDFDatatype> extractDatatype(TerminalNode langNode, TurtleOBDAParser.IriContext iri) {
        return this.literalTemplateFactory.extractDatatype(Optional.ofNullable(langNode).map(l -> l.getText().substring(1).toLowerCase()), Optional.ofNullable(iri).map(i -> (ImmutableTerm)i.accept(this)).filter(term -> term instanceof IRIConstant).map(term -> (IRIConstant)term).map(IRIConstant::getIRI));
    }

    @Override
    public ImmutableTerm visitBooleanLiteral(TurtleOBDAParser.BooleanLiteralContext ctx) {
        return this.termFactory.getRDFLiteralConstant(ctx.getText(), XSD.BOOLEAN);
    }

    @Override
    public ImmutableTerm visitIntegerLiteral(TurtleOBDAParser.IntegerLiteralContext ctx) {
        return this.termFactory.getRDFLiteralConstant(ctx.INTEGER().getText(), XSD.INTEGER);
    }

    @Override
    public ImmutableTerm visitDoubleLiteral(TurtleOBDAParser.DoubleLiteralContext ctx) {
        return this.termFactory.getRDFLiteralConstant(ctx.DOUBLE().getText(), XSD.DOUBLE);
    }

    @Override
    public ImmutableTerm visitDecimalLiteral(TurtleOBDAParser.DecimalLiteralContext ctx) {
        return this.termFactory.getRDFLiteralConstant(ctx.DECIMAL().getText(), XSD.DECIMAL);
    }
}

