/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.impl;

import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.spec.OBDASpecInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.rdf.api.Graph;

public class OBDASpecInputImpl
implements OBDASpecInput {
    private final ImmutableMap<String, File> files;
    private final ImmutableMap<String, Reader> readers;
    private final ImmutableMap<String, Graph> graphs;

    private OBDASpecInputImpl(ImmutableMap<String, File> files, ImmutableMap<String, Reader> readers, ImmutableMap<String, Graph> graphs) {
        this.files = files;
        this.readers = readers;
        this.graphs = graphs;
    }

    @Override
    public Optional<File> getFile(String key) {
        return Optional.ofNullable((File)this.files.get((Object)key));
    }

    @Override
    public Optional<Reader> getReader(String key) throws FileNotFoundException {
        if (this.readers.containsKey((Object)key)) {
            return Optional.of((Reader)this.readers.get((Object)key));
        }
        if (this.files.containsKey((Object)key)) {
            return Optional.of(new InputStreamReader((InputStream)new BOMInputStream((InputStream)new FileInputStream((File)this.files.get((Object)key)))));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Graph> getGraph(String key) {
        return Optional.ofNullable((Graph)this.graphs.get((Object)key));
    }

    public static class BuilderImpl
    implements OBDASpecInput.Builder {
        private final Map<String, File> files = new HashMap<String, File>();
        private final Map<String, Reader> readers = new HashMap<String, Reader>();
        private final Map<String, Graph> graphs = new HashMap<String, Graph>();

        @Override
        public OBDASpecInput.Builder addFile(String key, File file) {
            this.files.put(key, file);
            return this;
        }

        @Override
        public OBDASpecInput.Builder addReader(String key, Reader reader) {
            this.readers.put(key, reader);
            return this;
        }

        @Override
        public OBDASpecInput.Builder addGraph(String key, Graph graph) {
            this.graphs.put(key, graph);
            return this;
        }

        @Override
        public OBDASpecInput build() {
            return new OBDASpecInputImpl((ImmutableMap<String, File>)ImmutableMap.copyOf(this.files), (ImmutableMap<String, Reader>)ImmutableMap.copyOf(this.readers), (ImmutableMap<String, Graph>)ImmutableMap.copyOf(this.graphs));
        }
    }
}

