/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.fact.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.spec.fact.impl.AbstractFactExtractor;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.DataSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.DescriptionBT;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.EquivalencesDAG;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;

@Singleton
public class FactExtractorWithSaturatedTBox
extends AbstractFactExtractor {
    private static final String AUX_ROLE = "urn:AUX.ROLE";
    private final TermFactory termFactory;
    private final OntopMappingSettings settings;
    private final IRIConstant someValuesFrom;
    private final IRIConstant subClassOf;
    private final IRIConstant subPropertyOf;
    private final IRIConstant domain;
    private final IRIConstant range;
    private final IRIConstant rdfType;
    private final IRIConstant rdfsClass;
    private final IRIConstant owlClass;
    private final IRIConstant owlRestriction;
    private final IRIConstant onProperty;
    private final IRIConstant owlThing;
    private final IRIConstant rdfProperty;
    private final IRIConstant objectProperty;
    private final IRIConstant dataProperty;
    private final IRIConstant inverseOf;

    @Inject
    protected FactExtractorWithSaturatedTBox(TermFactory termFactory, OntopMappingSettings settings) {
        super(settings);
        this.settings = settings;
        this.termFactory = termFactory;
        this.someValuesFrom = termFactory.getConstantIRI(OWL.SOME_VALUES_FROM);
        this.subClassOf = termFactory.getConstantIRI(RDFS.SUBCLASSOF);
        this.subPropertyOf = termFactory.getConstantIRI(RDFS.SUBPROPERTYOF);
        this.domain = termFactory.getConstantIRI(RDFS.DOMAIN);
        this.range = termFactory.getConstantIRI(RDFS.RANGE);
        this.inverseOf = termFactory.getConstantIRI(OWL.INVERSE_OF);
        this.rdfType = termFactory.getConstantIRI(RDF.TYPE);
        this.rdfsClass = termFactory.getConstantIRI(RDFS.CLASS);
        this.owlClass = termFactory.getConstantIRI(OWL.CLASS);
        this.owlRestriction = termFactory.getConstantIRI(OWL.RESTRICTION);
        this.onProperty = termFactory.getConstantIRI(OWL.ON_PROPERTY);
        this.owlThing = termFactory.getConstantIRI(OWL.THING);
        this.rdfProperty = termFactory.getConstantIRI(RDF.PROPERTY);
        this.dataProperty = termFactory.getConstantIRI(OWL.DATATYPE_PROPERTY);
        this.objectProperty = termFactory.getConstantIRI(OWL.OBJECT_PROPERTY);
    }

    @Override
    protected Stream<RDFFact> extractTBox(ClassifiedTBox tbox) {
        ImmutableMap expressionIdMap = (ImmutableMap)Stream.concat(Stream.concat(this.generateIdEntries(tbox.classesDAG(), this::generateIdFromClassExpression), this.generateIdEntries(tbox.dataPropertiesDAG(), this::generateIdFromDataPropertyExpression)), this.generateIdEntries(tbox.objectPropertiesDAG(), this::generateIdFromObjectPropertyExpression)).filter(v -> !(v.getValue() instanceof BNode)).filter(v -> !((ObjectConstant)v.getValue()).getValue().contains(AUX_ROLE)).collect(ImmutableCollectors.toMap());
        EquivalencesDAG classDag = tbox.classesDAG();
        return Stream.concat(Stream.concat(this.extractFromDAG(classDag, e -> this.convertClassExpression((ClassExpression)e, (ImmutableMap<DescriptionBT, ObjectConstant>)expressionIdMap), (ImmutableMap<DescriptionBT, ObjectConstant>)expressionIdMap, ClassExpression.class, this.subClassOf), this.extractFromDAG(tbox.dataPropertiesDAG(), e -> this.convertDataPropertyExpression((DataPropertyExpression)e, (ImmutableMap<DescriptionBT, ObjectConstant>)expressionIdMap, (EquivalencesDAG<ClassExpression>)classDag), (ImmutableMap<DescriptionBT, ObjectConstant>)expressionIdMap, DataPropertyExpression.class, this.subPropertyOf)), this.extractFromDAG(tbox.objectPropertiesDAG(), e -> this.convertObjectPropertyExpression((ObjectPropertyExpression)e, (ImmutableMap<DescriptionBT, ObjectConstant>)expressionIdMap, (EquivalencesDAG<ClassExpression>)classDag), (ImmutableMap<DescriptionBT, ObjectConstant>)expressionIdMap, ObjectPropertyExpression.class, this.subPropertyOf));
    }

    private <T extends DescriptionBT> Stream<Map.Entry<DescriptionBT, ObjectConstant>> generateIdEntries(EquivalencesDAG<T> dag, Function<T, ObjectConstant> idGenerator) {
        return dag.stream().flatMap(e -> e.getMembers().stream()).map(m -> Maps.immutableEntry((Object)m, (Object)((ObjectConstant)idGenerator.apply(m))));
    }

    private ObjectConstant generateIdFromClassExpression(ClassExpression expression) {
        if (expression instanceof OClass) {
            return this.termFactory.getConstantIRI(((OClass)expression).getIRI());
        }
        return this.termFactory.getConstantBNode(UUID.randomUUID().toString());
    }

    private ObjectConstant generateIdFromDataPropertyExpression(DataPropertyExpression expression) {
        return this.termFactory.getConstantIRI(expression.getIRI());
    }

    private ObjectConstant generateIdFromObjectPropertyExpression(ObjectPropertyExpression expression) {
        return expression.isInverse() ? this.termFactory.getConstantBNode("op-inv" + expression.getIRI()) : this.termFactory.getConstantIRI(expression.getIRI());
    }

    private <T extends DescriptionBT> Stream<RDFFact> extractFromDAG(EquivalencesDAG<T> dag, Function<T, Stream<RDFFact>> expressionConverter, ImmutableMap<DescriptionBT, ObjectConstant> expressionIdMap, Class<T> expressionClass, IRIConstant subClassOrSubProperty) {
        return Stream.concat(expressionIdMap.keySet().stream().filter(expressionClass::isInstance).filter(v -> !(expressionIdMap.get(v) instanceof BNode)).flatMap(e -> (Stream)expressionConverter.apply(e)), this.extractSub(dag, subClassOrSubProperty, expressionIdMap));
    }

    private <T extends DescriptionBT> Stream<RDFFact> extractSub(EquivalencesDAG<T> dag, IRIConstant subPredicateProperty, ImmutableMap<DescriptionBT, ObjectConstant> expressionIdMap) {
        return dag.stream().flatMap(supEq -> supEq.getMembers().stream().flatMap(sup -> dag.getSub(supEq).stream().flatMap(subEq -> subEq.getMembers().stream().filter(sub -> !Objects.isNull(expressionIdMap.get(sub)) && !Objects.isNull(expressionIdMap.get(sup))).map(sub -> RDFFact.createTripleFact((ObjectConstant)((ObjectConstant)expressionIdMap.get(sub)), (IRIConstant)subPredicateProperty, (RDFConstant)((RDFConstant)expressionIdMap.get(sup)))))));
    }

    private Stream<RDFFact> convertClassExpression(ClassExpression e, ImmutableMap<DescriptionBT, ObjectConstant> expressionIdMap) {
        ObjectConstant classId = (ObjectConstant)expressionIdMap.get((Object)e);
        Stream<RDFFact> common = Stream.of(RDFFact.createTripleFact((ObjectConstant)classId, (IRIConstant)this.rdfType, (RDFConstant)this.rdfsClass), RDFFact.createTripleFact((ObjectConstant)classId, (IRIConstant)this.rdfType, (RDFConstant)this.owlClass));
        if (e instanceof OClass) {
            return common;
        }
        if (e instanceof ObjectSomeValuesFrom) {
            return Stream.concat(common, this.extractFactsFromRestriction(classId, (ObjectConstant)expressionIdMap.get((Object)((ObjectSomeValuesFrom)e).getProperty())));
        }
        if (e instanceof DataSomeValuesFrom) {
            return Stream.concat(common, this.extractFactsFromRestriction(classId, (ObjectConstant)expressionIdMap.get((Object)((DataSomeValuesFrom)e).getProperty())));
        }
        throw new MinorOntopInternalBugException("Unexpected class expression");
    }

    private Stream<RDFFact> extractFactsFromRestriction(ObjectConstant classId, ObjectConstant propertyId) {
        return Stream.of(RDFFact.createTripleFact((ObjectConstant)classId, (IRIConstant)this.rdfType, (RDFConstant)this.owlRestriction), RDFFact.createTripleFact((ObjectConstant)classId, (IRIConstant)this.onProperty, (RDFConstant)propertyId), RDFFact.createTripleFact((ObjectConstant)classId, (IRIConstant)this.someValuesFrom, (RDFConstant)this.owlThing));
    }

    private Stream<RDFFact> convertDataPropertyExpression(DataPropertyExpression e, ImmutableMap<DescriptionBT, ObjectConstant> expressionIdMap, EquivalencesDAG<ClassExpression> classDag) {
        ObjectConstant propertyId = (ObjectConstant)expressionIdMap.get((Object)e);
        Stream<RDFFact> basics = Stream.of(RDFFact.createTripleFact((ObjectConstant)propertyId, (IRIConstant)this.rdfType, (RDFConstant)this.rdfProperty), RDFFact.createTripleFact((ObjectConstant)propertyId, (IRIConstant)this.rdfType, (RDFConstant)this.dataProperty));
        return Stream.concat(basics, e.getAllDomainRestrictions().stream().flatMap(c -> this.extractSubDomainOrRange(propertyId, (ClassExpression)c, this.domain, expressionIdMap, classDag)));
    }

    private Stream<RDFFact> extractSubDomainOrRange(ObjectConstant propertyId, ClassExpression classExpression, IRIConstant rangeOrDomainProperty, ImmutableMap<DescriptionBT, ObjectConstant> expressionIdMap, EquivalencesDAG<ClassExpression> classDag) {
        Equivalences eq = classDag.getVertex((Object)classExpression);
        if (this.settings.areSuperClassesOfDomainRangeInferred()) {
            return classDag.getSuper(eq).stream().flatMap(supEq -> supEq.stream().filter(sup -> sup instanceof OClass).map(sup -> RDFFact.createTripleFact((ObjectConstant)propertyId, (IRIConstant)rangeOrDomainProperty, (RDFConstant)((RDFConstant)expressionIdMap.get(sup)))));
        }
        return classDag.getDirectSuper(eq).stream().flatMap(supEq -> supEq.stream().filter(sup -> sup instanceof OClass).map(sup -> RDFFact.createTripleFact((ObjectConstant)propertyId, (IRIConstant)rangeOrDomainProperty, (RDFConstant)((RDFConstant)expressionIdMap.get(sup)))));
    }

    private Stream<RDFFact> convertObjectPropertyExpression(ObjectPropertyExpression e, ImmutableMap<DescriptionBT, ObjectConstant> expressionIdMap, EquivalencesDAG<ClassExpression> classDag) {
        ObjectConstant propertyId = (ObjectConstant)expressionIdMap.get((Object)e);
        return Stream.concat(Stream.concat(Stream.concat(Stream.concat(Stream.of(RDFFact.createTripleFact((ObjectConstant)propertyId, (IRIConstant)this.rdfType, (RDFConstant)this.rdfProperty), RDFFact.createTripleFact((ObjectConstant)propertyId, (IRIConstant)this.rdfType, (RDFConstant)this.objectProperty)), this.extractSubDomainOrRange(propertyId, (ClassExpression)e.getDomain(), this.domain, expressionIdMap, classDag)), this.extractSubDomainOrRange(propertyId, (ClassExpression)e.getRange(), this.range, expressionIdMap, classDag)), this.extractFactsFromSubClassRestriction(propertyId, (ClassExpression)e.getRange(), expressionIdMap, classDag)), this.extractInverse(propertyId, e, expressionIdMap, classDag));
    }

    private Stream<RDFFact> extractFactsFromSubClassRestriction(ObjectConstant propertyId, ClassExpression classExpression, ImmutableMap<DescriptionBT, ObjectConstant> expressionIdMap, EquivalencesDAG<ClassExpression> classDag) {
        boolean restrictionPresent;
        Equivalences eq = classDag.getVertex((Object)classExpression);
        boolean bl = restrictionPresent = classDag.getDirectSub(eq).stream().map(c -> c.toString()).anyMatch(c -> c.contains(AUX_ROLE)) && eq.getMembers().size() == 1 && classDag.getDirectSuper(eq).size() == 0;
        if (restrictionPresent) {
            BNode newBNode = this.termFactory.getConstantBNode(UUID.randomUUID().toString());
            Stream<RDFFact> restriction = Stream.of(RDFFact.createTripleFact((ObjectConstant)newBNode, (IRIConstant)this.rdfType, (RDFConstant)this.owlRestriction));
            Stream<RDFFact> restrictionOnProperty = Stream.of(RDFFact.createTripleFact((ObjectConstant)newBNode, (IRIConstant)this.onProperty, (RDFConstant)propertyId));
            Stream restrictionSomeValuesFrom = classDag.getDirectSub(eq).stream().flatMap(sup -> classDag.getSuper(sup).stream().flatMap(supEq2 -> supEq2.stream().filter(sup2 -> sup2 instanceof OClass).map(sup3 -> RDFFact.createTripleFact((ObjectConstant)newBNode, (IRIConstant)this.someValuesFrom, (RDFConstant)((RDFConstant)expressionIdMap.get(sup3))))));
            Stream<RDFFact> newBNodeclasses = Stream.of(RDFFact.createTripleFact((ObjectConstant)newBNode, (IRIConstant)this.rdfType, (RDFConstant)this.rdfsClass), RDFFact.createTripleFact((ObjectConstant)newBNode, (IRIConstant)this.rdfType, (RDFConstant)this.owlClass));
            Stream restrictionSubClasses = classDag.getSub(eq).stream().flatMap(supEq -> supEq.stream().filter(sup -> sup instanceof OClass).map(sup -> RDFFact.createTripleFact((ObjectConstant)((ObjectConstant)expressionIdMap.get(sup)), (IRIConstant)this.subClassOf, (RDFConstant)newBNode)));
            return Stream.concat(restriction, Stream.concat(restrictionOnProperty, Stream.concat(restrictionSomeValuesFrom, Stream.concat(newBNodeclasses, restrictionSubClasses))));
        }
        return Stream.of(new RDFFact[0]);
    }

    private Stream<RDFFact> extractInverse(ObjectConstant propertyId, ObjectPropertyExpression e, ImmutableMap<DescriptionBT, ObjectConstant> expressionIdMap, EquivalencesDAG<ClassExpression> classDag) {
        Equivalences eq = classDag.getVertex((Object)e.getInverse().getDomain());
        return eq.getMembers().stream().filter(m -> m instanceof ObjectSomeValuesFrom).map(m -> (ObjectSomeValuesFrom)m).filter(m -> !m.getProperty().isInverse()).filter(m -> !m.getProperty().toString().contains(AUX_ROLE)).map(m -> RDFFact.createTripleFact((ObjectConstant)propertyId, (IRIConstant)this.inverseOf, (RDFConstant)((RDFConstant)expressionIdMap.get((Object)m.getProperty()))));
    }
}

