/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec;

import it.unibz.inf.ontop.spec.impl.OBDASpecInputImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.Optional;
import org.apache.commons.rdf.api.Graph;

public interface OBDASpecInput {
    public static final String MAPPING_KEY = "mapping";
    public static final String CONSTRAINT_KEY = "constraint";
    public static final String DBMETADATA_KEY = "db-metadata";
    public static final String LENSES_KEY = "lenses";
    public static final String SPARQL_RULES_KEY = "sparql-rules";

    @Deprecated
    public Optional<File> getFile(String var1);

    public Optional<Reader> getReader(String var1) throws FileNotFoundException;

    public Optional<Graph> getGraph(String var1);

    public static Builder defaultBuilder() {
        return new OBDASpecInputImpl.BuilderImpl();
    }

    default public Optional<Reader> getMappingReader() throws FileNotFoundException {
        return this.getReader(MAPPING_KEY);
    }

    default public Optional<Graph> getMappingGraph() {
        return this.getGraph(MAPPING_KEY);
    }

    default public Optional<File> getConstraintFile() {
        return this.getFile(CONSTRAINT_KEY);
    }

    default public Optional<Reader> getDBMetadataReader() throws FileNotFoundException {
        return this.getReader(DBMETADATA_KEY);
    }

    default public Optional<Reader> getLensesReader() throws FileNotFoundException {
        return this.getReader(LENSES_KEY);
    }

    default public Optional<Reader> getSparqlRulesReader() throws FileNotFoundException {
        return this.getReader(SPARQL_RULES_KEY);
    }

    public static interface Builder {
        public Builder addFile(String var1, File var2);

        public Builder addReader(String var1, Reader var2);

        public Builder addGraph(String var1, Graph var2);

        public OBDASpecInput build();

        default public Builder addMappingFile(File mappingFile) {
            return this.addFile(OBDASpecInput.MAPPING_KEY, mappingFile);
        }

        default public Builder addMappingReader(Reader mappingReader) {
            return this.addReader(OBDASpecInput.MAPPING_KEY, mappingReader);
        }

        default public Builder addMappingGraph(Graph mappingGraph) {
            return this.addGraph(OBDASpecInput.MAPPING_KEY, mappingGraph);
        }

        default public Builder addConstraintFile(File constraintFile) {
            return this.addFile(OBDASpecInput.CONSTRAINT_KEY, constraintFile);
        }

        default public Builder addDBMetadataFile(File dbMetadataFile) {
            return this.addFile(OBDASpecInput.DBMETADATA_KEY, dbMetadataFile);
        }

        default public Builder addDBMetadataReader(Reader dbMetadataReader) {
            return this.addReader(OBDASpecInput.DBMETADATA_KEY, dbMetadataReader);
        }

        default public Builder addLensesFile(File lensesFile) {
            return this.addFile(OBDASpecInput.LENSES_KEY, lensesFile);
        }

        default public Builder addLensesReader(Reader lensesReader) {
            return this.addReader(OBDASpecInput.LENSES_KEY, lensesReader);
        }

        default public Builder addSparqlRuleFile(File sparqlRuleFile) {
            return this.addFile(OBDASpecInput.SPARQL_RULES_KEY, sparqlRuleFile);
        }

        default public Builder addSparqlRuleReader(Reader sparqlRuleReader) {
            return this.addReader(OBDASpecInput.SPARQL_RULES_KEY, sparqlRuleReader);
        }
    }
}

