/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.MissingInputMappingException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopKGQuerySettings;
import it.unibz.inf.ontop.injection.OntopMappingConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.impl.FactsSupplier;
import it.unibz.inf.ontop.injection.impl.OntologySupplier;
import it.unibz.inf.ontop.injection.impl.OntopKGQueryConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopMappingModule;
import it.unibz.inf.ontop.injection.impl.OntopMappingSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopOBDAConfigurationImpl;
import it.unibz.inf.ontop.spec.OBDASpecInput;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.OBDASpecificationExtractor;
import it.unibz.inf.ontop.spec.mapping.TMappingExclusionConfig;
import it.unibz.inf.ontop.spec.mapping.pp.PreProcessedMapping;
import it.unibz.inf.ontop.spec.mapping.pp.PreProcessedTriplesMap;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import java.io.File;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.Graph;

public class OntopMappingConfigurationImpl
extends OntopKGQueryConfigurationImpl
implements OntopMappingConfiguration {
    private final OntopMappingSettings settings;
    private final OntopMappingOptions options;

    OntopMappingConfigurationImpl(OntopMappingSettings settings, OntopMappingOptions options) {
        super((OntopKGQuerySettings)settings, options.queryOptions);
        this.settings = settings;
        this.options = options;
    }

    OntopMappingConfigurationImpl(OntopMappingSettings settings, OntopMappingOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopKGQuerySettings)settings, options.queryOptions, injectorSupplier);
        this.settings = settings;
        this.options = options;
    }

    @Override
    public Optional<TMappingExclusionConfig> getTmappingExclusions() {
        return this.options.excludeFromTMappings;
    }

    @Override
    public OntopMappingSettings getSettings() {
        return this.settings;
    }

    protected OBDASpecification loadOBDASpecification() throws OBDASpecificationException {
        return this.loadSpecification(Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty, Optional::empty);
    }

    OBDASpecification loadSpecification(OntologySupplier ontologySupplier, FactsSupplier factsSupplier, Supplier<Optional<? extends PreProcessedMapping<? extends PreProcessedTriplesMap>>> ppMappingSupplier, Supplier<Optional<File>> mappingFileSupplier, Supplier<Optional<Reader>> mappingReaderSupplier, Supplier<Optional<Graph>> mappingGraphSupplier, Supplier<Optional<File>> constraintFileSupplier, Supplier<Optional<File>> dbMetadataFileSupplier, Supplier<Optional<Reader>> dbMetadataReaderSupplier, Supplier<Optional<File>> lensesSupplier, Supplier<Optional<Reader>> lensesReaderSupplier) throws OBDASpecificationException {
        OBDASpecificationExtractor extractor = (OBDASpecificationExtractor)this.getInjector().getInstance(OBDASpecificationExtractor.class);
        Optional<Ontology> optionalOntology = ontologySupplier.get();
        ImmutableSet<RDFFact> optionalFacts = factsSupplier.get().orElse((ImmutableSet<RDFFact>)ImmutableSet.of());
        Optional<? extends PreProcessedMapping<? extends PreProcessedTriplesMap>> optionalPPMapping = ppMappingSupplier.get();
        OBDASpecInput.Builder specInputBuilder = OBDASpecInput.defaultBuilder();
        constraintFileSupplier.get().ifPresent(specInputBuilder::addConstraintFile);
        dbMetadataFileSupplier.get().ifPresent(specInputBuilder::addDBMetadataFile);
        dbMetadataReaderSupplier.get().ifPresent(specInputBuilder::addDBMetadataReader);
        lensesSupplier.get().ifPresent(specInputBuilder::addLensesFile);
        lensesReaderSupplier.get().ifPresent(specInputBuilder::addLensesReader);
        this.options.sparqlRulesFile.ifPresent(specInputBuilder::addSparqlRuleFile);
        this.options.sparqlRulesReader.ifPresent(specInputBuilder::addSparqlRuleReader);
        if (optionalPPMapping.isPresent()) {
            PreProcessedMapping<? extends PreProcessedTriplesMap> ppMapping = optionalPPMapping.get();
            return extractor.extract(specInputBuilder.build(), ppMapping, optionalOntology, optionalFacts);
        }
        Optional<File> optionalMappingFile = mappingFileSupplier.get();
        if (optionalMappingFile.isPresent()) {
            specInputBuilder.addMappingFile(optionalMappingFile.get());
            return extractor.extract(specInputBuilder.build(), optionalOntology, optionalFacts);
        }
        Optional<Reader> optionalMappingReader = mappingReaderSupplier.get();
        if (optionalMappingReader.isPresent()) {
            specInputBuilder.addMappingReader(optionalMappingReader.get());
            return extractor.extract(specInputBuilder.build(), optionalOntology, optionalFacts);
        }
        Optional<Graph> optionalMappingGraph = mappingGraphSupplier.get();
        if (optionalMappingGraph.isPresent()) {
            specInputBuilder.addMappingGraph(optionalMappingGraph.get());
            return extractor.extract(specInputBuilder.build(), optionalOntology, optionalFacts);
        }
        throw new MissingInputMappingException();
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), Stream.of(new OntopMappingModule(this)));
    }

    public static class BuilderImpl
    extends OntopMappingBuilderMixin<BuilderImpl> {
        @Override
        public OntopMappingConfiguration build() {
            Properties properties = this.generateProperties();
            OntopMappingSettingsImpl settings = new OntopMappingSettingsImpl(properties);
            OntopMappingOptions options = this.generateMappingOptions();
            return new OntopMappingConfigurationImpl(settings, options);
        }

        protected BuilderImpl self() {
            return this;
        }
    }

    protected static abstract class OntopMappingBuilderMixin<B extends OntopMappingConfiguration.Builder<B>>
    extends OntopKGQueryConfigurationImpl.OntopKGQueryBuilderMixin<B>
    implements OntopMappingConfiguration.Builder<B> {
        private final DefaultOntopMappingBuilderFragment<B> mappingBuilderFragment = new DefaultOntopMappingBuilderFragment<B>(){

            @Override
            protected B self() {
                return (OntopMappingConfiguration.Builder)this.self();
            }
        };
        private boolean isMappingDefined = false;
        private boolean isDBMetadataDefined = false;
        private boolean areLensesDefined;

        OntopMappingBuilderMixin() {
        }

        @Override
        public B tMappingExclusionConfig(@Nonnull TMappingExclusionConfig config) {
            return this.mappingBuilderFragment.tMappingExclusionConfig(config);
        }

        @Override
        public B enableOntologyAnnotationQuerying(boolean queryingAnnotationsInOntology) {
            return this.mappingBuilderFragment.enableOntologyAnnotationQuerying(queryingAnnotationsInOntology);
        }

        @Override
        public B enableDefaultDatatypeInference(boolean inferDefaultDatatype) {
            return this.mappingBuilderFragment.enableDefaultDatatypeInference(inferDefaultDatatype);
        }

        @Override
        public B sparqlRulesFile(@Nonnull File file) {
            return this.mappingBuilderFragment.sparqlRulesFile(file);
        }

        @Override
        public B sparqlRulesFile(@Nonnull String path) {
            return this.mappingBuilderFragment.sparqlRulesFile(path);
        }

        @Override
        public B sparqlRulesReader(@Nonnull Reader reader) {
            return this.mappingBuilderFragment.sparqlRulesReader(reader);
        }

        protected final OntopMappingOptions generateMappingOptions() {
            return this.generateMappingOptions(this.generateOBDAOptions());
        }

        protected final OntopMappingOptions generateMappingOptions(OntopOBDAConfigurationImpl.OntopOBDAOptions obdaOptions) {
            return this.generateMappingOptions(this.generateKGQueryOptions(obdaOptions));
        }

        protected final OntopMappingOptions generateMappingOptions(OntopKGQueryConfigurationImpl.OntopKGQueryOptions queryOptions) {
            return this.mappingBuilderFragment.generateMappingOptions(queryOptions);
        }

        protected Properties generateProperties() {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)super.generateProperties());
            properties.putAll((Map<?, ?>)this.mappingBuilderFragment.generateProperties());
            return properties;
        }

        protected final void declareDBMetadataDefined() {
            if (this.isOBDASpecificationAssigned()) {
                throw new InvalidOntopConfigurationException("The OBDA specification has already been assigned");
            }
            this.isDBMetadataDefined = true;
        }

        protected final void declareLensesDefined() {
            if (this.isOBDASpecificationAssigned()) {
                throw new InvalidOntopConfigurationException("The OBDA specification has already been assigned");
            }
            this.areLensesDefined = true;
        }

        protected void declareOBDASpecificationAssigned() {
            super.declareOBDASpecificationAssigned();
            if (this.isDBMetadataDefined) {
                throw new InvalidOntopConfigurationException("DBMetadata is already defined, cannot assign the OBDA specification");
            }
            if (this.isMappingDefined()) {
                throw new InvalidOntopConfigurationException("The mapping is already defined, cannot assign the OBDA specification");
            }
            if (this.areLensesDefined) {
                throw new InvalidOntopConfigurationException("Lenses are already defined, cannot assign the OBDA specification");
            }
        }

        protected final void declareMappingDefined() {
            if (this.isOBDASpecificationAssigned()) {
                throw new InvalidOntopConfigurationException("The OBDA specification has already been assigned");
            }
            if (this.isMappingDefined) {
                throw new InvalidOntopConfigurationException("The mapping is already defined");
            }
            this.isMappingDefined = true;
        }

        protected final boolean isMappingDefined() {
            return this.isMappingDefined;
        }
    }

    protected static abstract class DefaultOntopMappingBuilderFragment<B extends OntopMappingConfiguration.Builder<B>>
    implements OntopMappingConfiguration.OntopMappingBuilderFragment<B> {
        private Optional<Boolean> queryingAnnotationsInOntology = Optional.empty();
        private Optional<Boolean> inferDefaultDatatype = Optional.empty();
        private Optional<TMappingExclusionConfig> excludeFromTMappings = Optional.empty();
        private Optional<File> sparqlRulesFile = Optional.empty();
        private Optional<Reader> sparqlRulesReader = Optional.empty();

        protected DefaultOntopMappingBuilderFragment() {
        }

        protected abstract B self();

        @Override
        public B tMappingExclusionConfig(@Nonnull TMappingExclusionConfig config) {
            this.excludeFromTMappings = Optional.of(config);
            return this.self();
        }

        @Override
        public B enableOntologyAnnotationQuerying(boolean queryingAnnotationsInOntology) {
            this.queryingAnnotationsInOntology = Optional.of(queryingAnnotationsInOntology);
            return this.self();
        }

        @Override
        public B enableDefaultDatatypeInference(boolean inferDefaultDatatype) {
            this.inferDefaultDatatype = Optional.of(inferDefaultDatatype);
            return this.self();
        }

        @Override
        public B sparqlRulesFile(@Nonnull File file) {
            this.sparqlRulesFile = Optional.of(file);
            return this.self();
        }

        @Override
        public B sparqlRulesFile(@Nonnull String path) {
            return this.sparqlRulesFile(new File(path));
        }

        @Override
        public B sparqlRulesReader(@Nonnull Reader reader) {
            this.sparqlRulesReader = Optional.of(reader);
            return this.self();
        }

        protected final OntopMappingOptions generateMappingOptions(OntopKGQueryConfigurationImpl.OntopKGQueryOptions queryOptions) {
            return new OntopMappingOptions(this.excludeFromTMappings, this.sparqlRulesFile, this.sparqlRulesReader, queryOptions);
        }

        protected Properties generateProperties() {
            Properties properties = new Properties();
            this.queryingAnnotationsInOntology.ifPresent(b -> properties.put("ontop.queryOntologyAnnotation", b));
            this.inferDefaultDatatype.ifPresent(b -> properties.put("ontop.inferDefaultDatatype", b));
            return properties;
        }
    }

    static class OntopMappingOptions {
        final OntopKGQueryConfigurationImpl.OntopKGQueryOptions queryOptions;
        private final Optional<TMappingExclusionConfig> excludeFromTMappings;
        final Optional<File> sparqlRulesFile;
        final Optional<Reader> sparqlRulesReader;

        private OntopMappingOptions(Optional<TMappingExclusionConfig> excludeFromTMappings, Optional<File> sparqlRulesFile, Optional<Reader> sparqlRulesReader, OntopKGQueryConfigurationImpl.OntopKGQueryOptions queryOptions) {
            this.excludeFromTMappings = excludeFromTMappings;
            this.queryOptions = queryOptions;
            this.sparqlRulesFile = sparqlRulesFile;
            this.sparqlRulesReader = sparqlRulesReader;
        }
    }
}

