/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ExecutionResultAction;
import co.elastic.clients.elasticsearch.watcher.ExecutionResultCondition;
import co.elastic.clients.elasticsearch.watcher.ExecutionResultInput;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ExecutionResult
implements JsonpSerializable {
    private final List<ExecutionResultAction> actions;
    private final ExecutionResultCondition condition;
    private final long executionDuration;
    private final DateTime executionTime;
    private final ExecutionResultInput input;
    public static final JsonpDeserializer<ExecutionResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutionResult::setupExecutionResultDeserializer);

    private ExecutionResult(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiableRequired(builder.actions, (Object)this, "actions");
        this.condition = ApiTypeHelper.requireNonNull(builder.condition, this, "condition");
        this.executionDuration = ApiTypeHelper.requireNonNull(builder.executionDuration, (Object)this, "executionDuration", 0L);
        this.executionTime = ApiTypeHelper.requireNonNull(builder.executionTime, this, "executionTime");
        this.input = ApiTypeHelper.requireNonNull(builder.input, this, "input");
    }

    public static ExecutionResult of(Function<Builder, ObjectBuilder<ExecutionResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ExecutionResultAction> actions() {
        return this.actions;
    }

    public final ExecutionResultCondition condition() {
        return this.condition;
    }

    public final long executionDuration() {
        return this.executionDuration;
    }

    public final DateTime executionTime() {
        return this.executionTime;
    }

    public final ExecutionResultInput input() {
        return this.input;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartArray();
            for (ExecutionResultAction item0 : this.actions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("condition");
        this.condition.serialize(generator, mapper);
        generator.writeKey("execution_duration");
        generator.write(this.executionDuration);
        generator.writeKey("execution_time");
        this.executionTime.serialize(generator, mapper);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupExecutionResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(ExecutionResultAction._DESERIALIZER), "actions");
        op.add(Builder::condition, ExecutionResultCondition._DESERIALIZER, "condition");
        op.add(Builder::executionDuration, JsonpDeserializer.longDeserializer(), "execution_duration");
        op.add(Builder::executionTime, DateTime._DESERIALIZER, "execution_time");
        op.add(Builder::input, ExecutionResultInput._DESERIALIZER, "input");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ExecutionResult> {
        private List<ExecutionResultAction> actions;
        private ExecutionResultCondition condition;
        private Long executionDuration;
        private DateTime executionTime;
        private ExecutionResultInput input;

        public final Builder actions(List<ExecutionResultAction> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        public final Builder actions(ExecutionResultAction value, ExecutionResultAction ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        public final Builder actions(Function<ExecutionResultAction.Builder, ObjectBuilder<ExecutionResultAction>> fn) {
            return this.actions(fn.apply(new ExecutionResultAction.Builder()).build(), new ExecutionResultAction[0]);
        }

        public final Builder condition(ExecutionResultCondition value) {
            this.condition = value;
            return this;
        }

        public final Builder condition(Function<ExecutionResultCondition.Builder, ObjectBuilder<ExecutionResultCondition>> fn) {
            return this.condition(fn.apply(new ExecutionResultCondition.Builder()).build());
        }

        public final Builder executionDuration(long value) {
            this.executionDuration = value;
            return this;
        }

        public final Builder executionTime(DateTime value) {
            this.executionTime = value;
            return this;
        }

        public final Builder input(ExecutionResultInput value) {
            this.input = value;
            return this;
        }

        public final Builder input(Function<ExecutionResultInput.Builder, ObjectBuilder<ExecutionResultInput>> fn) {
            return this.input(fn.apply(new ExecutionResultInput.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExecutionResult build() {
            this._checkSingleUse();
            return new ExecutionResult(this);
        }
    }
}

