/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;

public class WellKnownEntities {
    public static Set<IRI> getWellKnownEntities() throws IOException {
        ImmutableSet vocabularyClasses = ClassPath.from((ClassLoader)WellKnownEntities.class.getClassLoader()).getTopLevelClasses("org.eclipse.rdf4j.model.vocabulary");
        HashSet<IRI> result = new HashSet<IRI>();
        for (ClassPath.ClassInfo classInfo : vocabularyClasses) {
            result.addAll(WellKnownEntities.getEntitiesFromVocabularyClass(classInfo.load()));
        }
        return result;
    }

    public static Set<IRI> getEntitiesFromVocabularyClass(Class<?> klass) {
        Field[] declaredFields;
        HashSet<IRI> result = new HashSet<IRI>();
        for (Field field : declaredFields = klass.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !field.getType().equals(IRI.class)) continue;
            try {
                result.add((IRI)field.get(klass));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return result;
    }
}

