/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.util.BytesRef;

public class CompositeInputIterator
implements InputIterator,
Closeable,
AutoCloseable {
    private Collection<InputIterator> delegates;
    private Iterator<InputIterator> delegatesIterator;
    private InputIterator delegate;

    CompositeInputIterator(Collection<InputIterator> delegates) {
        this.delegates = delegates;
        this.delegatesIterator = delegates.iterator();
        this.delegate = this.delegatesIterator.hasNext() ? this.delegatesIterator.next() : InputIterator.EMPTY;
    }

    public long weight() {
        return this.delegate.weight();
    }

    public BytesRef payload() {
        return this.delegate.payload();
    }

    public boolean hasPayloads() {
        return true;
    }

    public Set<BytesRef> contexts() {
        return this.delegate.contexts();
    }

    public boolean hasContexts() {
        return true;
    }

    public BytesRef next() throws IOException {
        BytesRef next = this.delegate.next();
        if (next == null && this.delegatesIterator.hasNext()) {
            this.delegate = this.delegatesIterator.next();
            return this.next();
        }
        return next;
    }

    @Override
    public void close() throws IOException {
        for (InputIterator itty : this.delegates) {
            if (!(itty instanceof Closeable)) continue;
            ((Closeable)itty).close();
        }
    }
}

