/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.autocomplete;

import com.ontotext.trree.plugin.autocomplete.AutocompletePlugin;
import com.ontotext.trree.plugin.autocomplete.IndexStatus;
import com.ontotext.trree.plugin.autocomplete.LabelConfig;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.EntityListener;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.PluginTransactionListener;
import com.ontotext.trree.sdk.StatementListener;
import gnu.trove.TLongObjectHashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutocompleteUpdateListener
implements EntityListener,
PluginTransactionListener,
StatementListener {
    private boolean newEntitiesAdded = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(AutocompleteUpdateListener.class);
    private final AutocompletePlugin plugin;
    private long firstEntityAddedWhileBuilding;
    private TLongObjectHashMap<String> labelsAddedWhileBuilding;
    private final Map<IRI, LabelConfig> unresolvedLabelConfigs;
    private boolean shutDownInitiated = false;

    public AutocompleteUpdateListener(AutocompletePlugin plugin) {
        this.plugin = plugin;
        this.labelsAddedWhileBuilding = new TLongObjectHashMap();
        this.unresolvedLabelConfigs = new HashMap<IRI, LabelConfig>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityAdded(long id, Value value, PluginConnection pluginConnection) {
        if (this.shutDownInitiated || !this.plugin.isPluginEnabled || this.plugin.autocompleteIndex == null) {
            return;
        }
        if (value instanceof IRI) {
            LabelConfig labelConfig;
            if (!this.unresolvedLabelConfigs.isEmpty() && (labelConfig = this.unresolvedLabelConfigs.get(value)) != null) {
                Map<IRI, LabelConfig> map = this.unresolvedLabelConfigs;
                synchronized (map) {
                    labelConfig.labelId = id;
                    this.unresolvedLabelConfigs.remove(value);
                }
            }
            if (this.shutDownInitiated || !this.plugin.isPluginEnabled || !this.plugin.actualShouldIndexIRIs) {
                return;
            }
            if (this.plugin.autocompleteIndex == null) {
                LOGGER.warn("Plugin index is empty");
                return;
            }
            if (this.plugin.autocompleteIndex.status() == IndexStatus.BUILDING) {
                if (this.firstEntityAddedWhileBuilding == 0L) {
                    this.firstEntityAddedWhileBuilding = id;
                }
            } else {
                this.newEntitiesAdded = true;
                this.plugin.autocompleteIndex.index(id, (IRI)value);
            }
        }
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        this.checkForEntitiesAddedWhileBuilding(pluginConnection.getEntities());
        if (!this.newEntitiesAdded) {
            return;
        }
        if (this.plugin.autocompleteIndex == null) {
            return;
        }
        try {
            this.plugin.autocompleteIndex.commitAndRefresh();
        }
        catch (IOException e) {
            throw new PluginException("Could not commit autocomplete index", (Throwable)e);
        }
        finally {
            this.newEntitiesAdded = false;
        }
    }

    public boolean statementAdded(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        for (LabelConfig labelConfig : this.plugin.labelConfigs) {
            if (predicate != labelConfig.labelId) continue;
            if (this.shutDownInitiated || !this.plugin.isPluginEnabled || this.plugin.autocompleteIndex == null) {
                return false;
            }
            this.updateLabel(subject, object, labelConfig, pluginConnection.getEntities());
        }
        return false;
    }

    public boolean statementRemoved(long subject, long predicate, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        for (LabelConfig labelConfig : this.plugin.labelConfigs) {
            if (predicate != labelConfig.labelId) continue;
            if (this.shutDownInitiated || !this.plugin.isPluginEnabled || this.plugin.autocompleteIndex == null) {
                return false;
            }
            this.updateLabel(0L, object, labelConfig, pluginConnection.getEntities());
        }
        return false;
    }

    private void updateLabel(long subject, long object, LabelConfig labelConfig, Entities entities) {
        String language = entities.getLanguage(object);
        if (labelConfig.languageMatches(language)) {
            String label = entities.get(object).stringValue();
            if (this.plugin.autocompleteIndex.status() == IndexStatus.BUILDING) {
                this.labelsAddedWhileBuilding.put(subject, (Object)label);
            } else {
                this.newEntitiesAdded = true;
                this.plugin.autocompleteIndex.index(subject, label);
            }
        }
    }

    public void transactionStarted(PluginConnection pluginConnection) {
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        if (!this.newEntitiesAdded) {
            return;
        }
        if (this.plugin.autocompleteIndex == null) {
            return;
        }
        try {
            this.plugin.autocompleteIndex.rollback();
        }
        catch (IOException e) {
            LOGGER.debug("Could not rollback autocomplete index when transaction was aborted", (Throwable)e);
        }
        finally {
            this.newEntitiesAdded = false;
        }
    }

    private void checkForEntitiesAddedWhileBuilding(Entities entities) {
        if (this.firstEntityAddedWhileBuilding > 0L) {
            while (this.firstEntityAddedWhileBuilding <= entities.size()) {
                Value value = entities.get(this.firstEntityAddedWhileBuilding);
                if (value instanceof IRI) {
                    this.newEntitiesAdded = true;
                    this.plugin.autocompleteIndex.index(this.firstEntityAddedWhileBuilding, (IRI)value);
                }
                ++this.firstEntityAddedWhileBuilding;
            }
            this.firstEntityAddedWhileBuilding = 0L;
        }
        if (!this.labelsAddedWhileBuilding.isEmpty()) {
            this.labelsAddedWhileBuilding.forEachEntry((id, label) -> {
                this.plugin.autocompleteIndex.index(id, (String)label);
                return true;
            });
            this.labelsAddedWhileBuilding = new TLongObjectHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAboutLabelConfig(LabelConfig labelConfig) {
        if (labelConfig.labelId <= 0L) {
            Map<IRI, LabelConfig> map = this.unresolvedLabelConfigs;
            synchronized (map) {
                this.unresolvedLabelConfigs.put(labelConfig.labelIRI, labelConfig);
            }
        }
    }

    void beforeShutDown() {
        this.shutDownInitiated = true;
    }
}

